@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.ListLocalRulestackCountriesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property localRulestackName LocalRulestack resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property skip
 * @property top
 */
public data class ListLocalRulestackCountriesPlainArgs(
    public val localRulestackName: String,
    public val resourceGroupName: String,
    public val skip: String? = null,
    public val top: Int? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.ListLocalRulestackCountriesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.ListLocalRulestackCountriesPlainArgs =
        com.pulumi.azurenative.cloudngfw.inputs.ListLocalRulestackCountriesPlainArgs.builder()
            .localRulestackName(localRulestackName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListLocalRulestackCountriesPlainArgs].
 */
@PulumiTagMarker
public class ListLocalRulestackCountriesPlainArgsBuilder internal constructor() {
    private var localRulestackName: String? = null

    private var resourceGroupName: String? = null

    private var skip: String? = null

    private var top: Int? = null

    /**
     * @param value LocalRulestack resource name
     */
    @JvmName("wmhytddlndtfyhhv")
    public suspend fun localRulestackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.localRulestackName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bdlujmqvwjpscgmt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("xnfecogbgydaswwd")
    public suspend fun skip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value
     */
    @JvmName("jafjsnmtuvysswjp")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListLocalRulestackCountriesPlainArgs = ListLocalRulestackCountriesPlainArgs(
        localRulestackName = localRulestackName ?: throw PulumiNullFieldException("localRulestackName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        skip = skip,
        top = top,
    )
}
