@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.MarketplaceDetailsArgs.builder
import com.pulumi.azurenative.cloudngfw.kotlin.enums.MarketplaceSubscriptionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * MarketplaceDetails of PAN Firewall resource
 * @property marketplaceSubscriptionStatus Marketplace Subscription Status
 * @property offerId Offer Id
 * @property publisherId Publisher Id
 */
public data class MarketplaceDetailsArgs(
    public val marketplaceSubscriptionStatus: Output<Either<String, MarketplaceSubscriptionStatus>>? =
        null,
    public val offerId: Output<String>,
    public val publisherId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.MarketplaceDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.MarketplaceDetailsArgs =
        com.pulumi.azurenative.cloudngfw.inputs.MarketplaceDetailsArgs.builder()
            .marketplaceSubscriptionStatus(
                marketplaceSubscriptionStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .offerId(offerId.applyValue({ args0 -> args0 }))
            .publisherId(publisherId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MarketplaceDetailsArgs].
 */
@PulumiTagMarker
public class MarketplaceDetailsArgsBuilder internal constructor() {
    private var marketplaceSubscriptionStatus: Output<Either<String, MarketplaceSubscriptionStatus>>? =
        null

    private var offerId: Output<String>? = null

    private var publisherId: Output<String>? = null

    /**
     * @param value Marketplace Subscription Status
     */
    @JvmName("qdbgjonoffcuycaq")
    public suspend fun marketplaceSubscriptionStatus(`value`: Output<Either<String, MarketplaceSubscriptionStatus>>) {
        this.marketplaceSubscriptionStatus = value
    }

    /**
     * @param value Offer Id
     */
    @JvmName("wyibwheydfmhiuce")
    public suspend fun offerId(`value`: Output<String>) {
        this.offerId = value
    }

    /**
     * @param value Publisher Id
     */
    @JvmName("oxaacmiidxibjxrc")
    public suspend fun publisherId(`value`: Output<String>) {
        this.publisherId = value
    }

    /**
     * @param value Marketplace Subscription Status
     */
    @JvmName("wwauxrvavupxvtcl")
    public suspend fun marketplaceSubscriptionStatus(`value`: Either<String, MarketplaceSubscriptionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplaceSubscriptionStatus = mapped
    }

    /**
     * @param value Marketplace Subscription Status
     */
    @JvmName("gtaqelbolihadeej")
    public fun marketplaceSubscriptionStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MarketplaceSubscriptionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.marketplaceSubscriptionStatus = mapped
    }

    /**
     * @param value Marketplace Subscription Status
     */
    @JvmName("bvepnpswhunxfjgw")
    public fun marketplaceSubscriptionStatus(`value`: MarketplaceSubscriptionStatus) {
        val toBeMapped = Either.ofRight<String, MarketplaceSubscriptionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.marketplaceSubscriptionStatus = mapped
    }

    /**
     * @param value Offer Id
     */
    @JvmName("ttwugiyeraanjchc")
    public suspend fun offerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offerId = mapped
    }

    /**
     * @param value Publisher Id
     */
    @JvmName("rytwjypkabaxpeim")
    public suspend fun publisherId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publisherId = mapped
    }

    internal fun build(): MarketplaceDetailsArgs = MarketplaceDetailsArgs(
        marketplaceSubscriptionStatus = marketplaceSubscriptionStatus,
        offerId = offerId ?: throw PulumiNullFieldException("offerId"),
        publisherId = publisherId ?: throw PulumiNullFieldException("publisherId"),
    )
}
