@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.NetworkProfileArgs.builder
import com.pulumi.azurenative.cloudngfw.kotlin.enums.EgressNat
import com.pulumi.azurenative.cloudngfw.kotlin.enums.NetworkType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Network settings for Firewall
 * @property egressNatIp Egress nat IP to use
 * @property enableEgressNat Enable egress NAT, enabled by default
 * @property networkType vnet or vwan, cannot be updated
 * @property publicIps List of IPs associated with the Firewall
 * @property trustedRanges Non-RFC 1918 address
 * @property vnetConfiguration Vnet configurations
 * @property vwanConfiguration Vwan configurations
 */
public data class NetworkProfileArgs(
    public val egressNatIp: Output<List<IPAddressArgs>>? = null,
    public val enableEgressNat: Output<Either<String, EgressNat>>,
    public val networkType: Output<Either<String, NetworkType>>,
    public val publicIps: Output<List<IPAddressArgs>>,
    public val trustedRanges: Output<List<String>>? = null,
    public val vnetConfiguration: Output<VnetConfigurationArgs>? = null,
    public val vwanConfiguration: Output<VwanConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.NetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.NetworkProfileArgs =
        com.pulumi.azurenative.cloudngfw.inputs.NetworkProfileArgs.builder()
            .egressNatIp(
                egressNatIp?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableEgressNat(
                enableEgressNat.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkType(
                networkType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicIps(
                publicIps.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .trustedRanges(trustedRanges?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vnetConfiguration(vnetConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vwanConfiguration(
                vwanConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkProfileArgs].
 */
@PulumiTagMarker
public class NetworkProfileArgsBuilder internal constructor() {
    private var egressNatIp: Output<List<IPAddressArgs>>? = null

    private var enableEgressNat: Output<Either<String, EgressNat>>? = null

    private var networkType: Output<Either<String, NetworkType>>? = null

    private var publicIps: Output<List<IPAddressArgs>>? = null

    private var trustedRanges: Output<List<String>>? = null

    private var vnetConfiguration: Output<VnetConfigurationArgs>? = null

    private var vwanConfiguration: Output<VwanConfigurationArgs>? = null

    /**
     * @param value Egress nat IP to use
     */
    @JvmName("kwyroaoshrkuwlun")
    public suspend fun egressNatIp(`value`: Output<List<IPAddressArgs>>) {
        this.egressNatIp = value
    }

    @JvmName("hgqsrfykjjgmrevt")
    public suspend fun egressNatIp(vararg values: Output<IPAddressArgs>) {
        this.egressNatIp = Output.all(values.asList())
    }

    /**
     * @param values Egress nat IP to use
     */
    @JvmName("hevpkiwtnwnpswpb")
    public suspend fun egressNatIp(values: List<Output<IPAddressArgs>>) {
        this.egressNatIp = Output.all(values)
    }

    /**
     * @param value Enable egress NAT, enabled by default
     */
    @JvmName("ptwgrfxxwdsgwksr")
    public suspend fun enableEgressNat(`value`: Output<Either<String, EgressNat>>) {
        this.enableEgressNat = value
    }

    /**
     * @param value vnet or vwan, cannot be updated
     */
    @JvmName("ptplfqgireipfvfu")
    public suspend fun networkType(`value`: Output<Either<String, NetworkType>>) {
        this.networkType = value
    }

    /**
     * @param value List of IPs associated with the Firewall
     */
    @JvmName("vpocvtwflgpnnnbg")
    public suspend fun publicIps(`value`: Output<List<IPAddressArgs>>) {
        this.publicIps = value
    }

    @JvmName("owynvwiutkxvaesc")
    public suspend fun publicIps(vararg values: Output<IPAddressArgs>) {
        this.publicIps = Output.all(values.asList())
    }

    /**
     * @param values List of IPs associated with the Firewall
     */
    @JvmName("theodjtubtclpohi")
    public suspend fun publicIps(values: List<Output<IPAddressArgs>>) {
        this.publicIps = Output.all(values)
    }

    /**
     * @param value Non-RFC 1918 address
     */
    @JvmName("sxdfmfsefljkksnj")
    public suspend fun trustedRanges(`value`: Output<List<String>>) {
        this.trustedRanges = value
    }

    @JvmName("gfutdhbkpayxlukh")
    public suspend fun trustedRanges(vararg values: Output<String>) {
        this.trustedRanges = Output.all(values.asList())
    }

    /**
     * @param values Non-RFC 1918 address
     */
    @JvmName("utfilcccscjtrxak")
    public suspend fun trustedRanges(values: List<Output<String>>) {
        this.trustedRanges = Output.all(values)
    }

    /**
     * @param value Vnet configurations
     */
    @JvmName("rdrbwgfmvgaypcji")
    public suspend fun vnetConfiguration(`value`: Output<VnetConfigurationArgs>) {
        this.vnetConfiguration = value
    }

    /**
     * @param value Vwan configurations
     */
    @JvmName("wtwmfkillwqowlne")
    public suspend fun vwanConfiguration(`value`: Output<VwanConfigurationArgs>) {
        this.vwanConfiguration = value
    }

    /**
     * @param value Egress nat IP to use
     */
    @JvmName("ejocnanpwcjvtatb")
    public suspend fun egressNatIp(`value`: List<IPAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressNatIp = mapped
    }

    /**
     * @param argument Egress nat IP to use
     */
    @JvmName("vbspqsnnxbtvrogd")
    public suspend fun egressNatIp(argument: List<suspend IPAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IPAddressArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.egressNatIp = mapped
    }

    /**
     * @param argument Egress nat IP to use
     */
    @JvmName("cckalnpynhgoxlxn")
    public suspend fun egressNatIp(vararg argument: suspend IPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IPAddressArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.egressNatIp = mapped
    }

    /**
     * @param argument Egress nat IP to use
     */
    @JvmName("isdyuptoqjnalpag")
    public suspend fun egressNatIp(argument: suspend IPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPAddressArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.egressNatIp = mapped
    }

    /**
     * @param values Egress nat IP to use
     */
    @JvmName("dafmgjmcixjeqdvf")
    public suspend fun egressNatIp(vararg values: IPAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.egressNatIp = mapped
    }

    /**
     * @param value Enable egress NAT, enabled by default
     */
    @JvmName("qcstscbsatuntmjs")
    public suspend fun enableEgressNat(`value`: Either<String, EgressNat>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableEgressNat = mapped
    }

    /**
     * @param value Enable egress NAT, enabled by default
     */
    @JvmName("hqysaxxsljyfbgly")
    public fun enableEgressNat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EgressNat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableEgressNat = mapped
    }

    /**
     * @param value Enable egress NAT, enabled by default
     */
    @JvmName("iylbkgbieofuroho")
    public fun enableEgressNat(`value`: EgressNat) {
        val toBeMapped = Either.ofRight<String, EgressNat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableEgressNat = mapped
    }

    /**
     * @param value vnet or vwan, cannot be updated
     */
    @JvmName("yebqrdxuoehebofd")
    public suspend fun networkType(`value`: Either<String, NetworkType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value vnet or vwan, cannot be updated
     */
    @JvmName("unwwleignkhynhis")
    public fun networkType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value vnet or vwan, cannot be updated
     */
    @JvmName("ctwljbutjwxffbou")
    public fun networkType(`value`: NetworkType) {
        val toBeMapped = Either.ofRight<String, NetworkType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value List of IPs associated with the Firewall
     */
    @JvmName("wpnmwfuaursghwvl")
    public suspend fun publicIps(`value`: List<IPAddressArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIps = mapped
    }

    /**
     * @param argument List of IPs associated with the Firewall
     */
    @JvmName("wgudxltbfycakwlf")
    public suspend fun publicIps(argument: List<suspend IPAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IPAddressArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.publicIps = mapped
    }

    /**
     * @param argument List of IPs associated with the Firewall
     */
    @JvmName("chvafgdgojfspiun")
    public suspend fun publicIps(vararg argument: suspend IPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IPAddressArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.publicIps = mapped
    }

    /**
     * @param argument List of IPs associated with the Firewall
     */
    @JvmName("lbwjsgkixxyqfsle")
    public suspend fun publicIps(argument: suspend IPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPAddressArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.publicIps = mapped
    }

    /**
     * @param values List of IPs associated with the Firewall
     */
    @JvmName("vorpamovfksjeoin")
    public suspend fun publicIps(vararg values: IPAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIps = mapped
    }

    /**
     * @param value Non-RFC 1918 address
     */
    @JvmName("ovaviikpceboflai")
    public suspend fun trustedRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedRanges = mapped
    }

    /**
     * @param values Non-RFC 1918 address
     */
    @JvmName("frepoiokiudfyocm")
    public suspend fun trustedRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedRanges = mapped
    }

    /**
     * @param value Vnet configurations
     */
    @JvmName("kuteugtmkbweafhf")
    public suspend fun vnetConfiguration(`value`: VnetConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetConfiguration = mapped
    }

    /**
     * @param argument Vnet configurations
     */
    @JvmName("kbiiruqtpqfgqbtc")
    public suspend fun vnetConfiguration(argument: suspend VnetConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VnetConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vnetConfiguration = mapped
    }

    /**
     * @param value Vwan configurations
     */
    @JvmName("jbgnkklgtrgtocte")
    public suspend fun vwanConfiguration(`value`: VwanConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vwanConfiguration = mapped
    }

    /**
     * @param argument Vwan configurations
     */
    @JvmName("uqeemjxdfqprmdjj")
    public suspend fun vwanConfiguration(argument: suspend VwanConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VwanConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vwanConfiguration = mapped
    }

    internal fun build(): NetworkProfileArgs = NetworkProfileArgs(
        egressNatIp = egressNatIp,
        enableEgressNat = enableEgressNat ?: throw PulumiNullFieldException("enableEgressNat"),
        networkType = networkType ?: throw PulumiNullFieldException("networkType"),
        publicIps = publicIps ?: throw PulumiNullFieldException("publicIps"),
        trustedRanges = trustedRanges,
        vnetConfiguration = vnetConfiguration,
        vwanConfiguration = vwanConfiguration,
    )
}
