@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.PanoramaConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Panorama Config
 * @property configString Base64 encoded string representing Panorama parameters to be used by Firewall to connect to Panorama. This string is generated via azure plugin in Panorama
 */
public data class PanoramaConfigArgs(
    public val configString: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.PanoramaConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.PanoramaConfigArgs =
        com.pulumi.azurenative.cloudngfw.inputs.PanoramaConfigArgs.builder()
            .configString(configString.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PanoramaConfigArgs].
 */
@PulumiTagMarker
public class PanoramaConfigArgsBuilder internal constructor() {
    private var configString: Output<String>? = null

    /**
     * @param value Base64 encoded string representing Panorama parameters to be used by Firewall to connect to Panorama. This string is generated via azure plugin in Panorama
     */
    @JvmName("jhfalujhdaojwbqm")
    public suspend fun configString(`value`: Output<String>) {
        this.configString = value
    }

    /**
     * @param value Base64 encoded string representing Panorama parameters to be used by Firewall to connect to Panorama. This string is generated via azure plugin in Panorama
     */
    @JvmName("wxwndvghqljyvypk")
    public suspend fun configString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configString = mapped
    }

    internal fun build(): PanoramaConfigArgs = PanoramaConfigArgs(
        configString = configString ?: throw PulumiNullFieldException("configString"),
    )
}
