@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.RulestackDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Associated rulestack details
 * @property location Rulestack location
 * @property resourceId Resource Id
 * @property rulestackId Associated rulestack Id
 */
public data class RulestackDetailsArgs(
    public val location: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val rulestackId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.RulestackDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.RulestackDetailsArgs =
        com.pulumi.azurenative.cloudngfw.inputs.RulestackDetailsArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .rulestackId(rulestackId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RulestackDetailsArgs].
 */
@PulumiTagMarker
public class RulestackDetailsArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var rulestackId: Output<String>? = null

    /**
     * @param value Rulestack location
     */
    @JvmName("mhoeddjcpajpijia")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Resource Id
     */
    @JvmName("ghkohyqmmwvmmtbn")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Associated rulestack Id
     */
    @JvmName("mnjydxgtjupxrghm")
    public suspend fun rulestackId(`value`: Output<String>) {
        this.rulestackId = value
    }

    /**
     * @param value Rulestack location
     */
    @JvmName("hvecottpfjjthmit")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Resource Id
     */
    @JvmName("dgnuicbxcimdornq")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Associated rulestack Id
     */
    @JvmName("rynwrxmcpufkytfy")
    public suspend fun rulestackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rulestackId = mapped
    }

    internal fun build(): RulestackDetailsArgs = RulestackDetailsArgs(
        location = location,
        resourceId = resourceId,
        rulestackId = rulestackId,
    )
}
