@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.SecurityServicesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * security services
 * @property antiSpywareProfile Anti spyware Profile data
 * @property antiVirusProfile anti virus profile data
 * @property dnsSubscription DNS Subscription profile data
 * @property fileBlockingProfile File blocking profile data
 * @property outboundTrustCertificate Trusted Egress Decryption profile data
 * @property outboundUnTrustCertificate Untrusted Egress Decryption profile data
 * @property urlFilteringProfile URL filtering profile data
 * @property vulnerabilityProfile IPs Vulnerability Profile Data
 */
public data class SecurityServicesArgs(
    public val antiSpywareProfile: Output<String>? = null,
    public val antiVirusProfile: Output<String>? = null,
    public val dnsSubscription: Output<String>? = null,
    public val fileBlockingProfile: Output<String>? = null,
    public val outboundTrustCertificate: Output<String>? = null,
    public val outboundUnTrustCertificate: Output<String>? = null,
    public val urlFilteringProfile: Output<String>? = null,
    public val vulnerabilityProfile: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.SecurityServicesArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.SecurityServicesArgs =
        com.pulumi.azurenative.cloudngfw.inputs.SecurityServicesArgs.builder()
            .antiSpywareProfile(antiSpywareProfile?.applyValue({ args0 -> args0 }))
            .antiVirusProfile(antiVirusProfile?.applyValue({ args0 -> args0 }))
            .dnsSubscription(dnsSubscription?.applyValue({ args0 -> args0 }))
            .fileBlockingProfile(fileBlockingProfile?.applyValue({ args0 -> args0 }))
            .outboundTrustCertificate(outboundTrustCertificate?.applyValue({ args0 -> args0 }))
            .outboundUnTrustCertificate(outboundUnTrustCertificate?.applyValue({ args0 -> args0 }))
            .urlFilteringProfile(urlFilteringProfile?.applyValue({ args0 -> args0 }))
            .vulnerabilityProfile(vulnerabilityProfile?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityServicesArgs].
 */
@PulumiTagMarker
public class SecurityServicesArgsBuilder internal constructor() {
    private var antiSpywareProfile: Output<String>? = null

    private var antiVirusProfile: Output<String>? = null

    private var dnsSubscription: Output<String>? = null

    private var fileBlockingProfile: Output<String>? = null

    private var outboundTrustCertificate: Output<String>? = null

    private var outboundUnTrustCertificate: Output<String>? = null

    private var urlFilteringProfile: Output<String>? = null

    private var vulnerabilityProfile: Output<String>? = null

    /**
     * @param value Anti spyware Profile data
     */
    @JvmName("hgendjiolbllavea")
    public suspend fun antiSpywareProfile(`value`: Output<String>) {
        this.antiSpywareProfile = value
    }

    /**
     * @param value anti virus profile data
     */
    @JvmName("veyfvrgexxcxyure")
    public suspend fun antiVirusProfile(`value`: Output<String>) {
        this.antiVirusProfile = value
    }

    /**
     * @param value DNS Subscription profile data
     */
    @JvmName("jdneefjtoxeulahw")
    public suspend fun dnsSubscription(`value`: Output<String>) {
        this.dnsSubscription = value
    }

    /**
     * @param value File blocking profile data
     */
    @JvmName("tatiexqnlyoxuxyr")
    public suspend fun fileBlockingProfile(`value`: Output<String>) {
        this.fileBlockingProfile = value
    }

    /**
     * @param value Trusted Egress Decryption profile data
     */
    @JvmName("yyoghyjehtriqunm")
    public suspend fun outboundTrustCertificate(`value`: Output<String>) {
        this.outboundTrustCertificate = value
    }

    /**
     * @param value Untrusted Egress Decryption profile data
     */
    @JvmName("wkcmydievtquhrat")
    public suspend fun outboundUnTrustCertificate(`value`: Output<String>) {
        this.outboundUnTrustCertificate = value
    }

    /**
     * @param value URL filtering profile data
     */
    @JvmName("ngbyoavwobxpanki")
    public suspend fun urlFilteringProfile(`value`: Output<String>) {
        this.urlFilteringProfile = value
    }

    /**
     * @param value IPs Vulnerability Profile Data
     */
    @JvmName("rtcojljqgrgescff")
    public suspend fun vulnerabilityProfile(`value`: Output<String>) {
        this.vulnerabilityProfile = value
    }

    /**
     * @param value Anti spyware Profile data
     */
    @JvmName("komlhumgjlmuglvi")
    public suspend fun antiSpywareProfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.antiSpywareProfile = mapped
    }

    /**
     * @param value anti virus profile data
     */
    @JvmName("rachocuscqnpccdi")
    public suspend fun antiVirusProfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.antiVirusProfile = mapped
    }

    /**
     * @param value DNS Subscription profile data
     */
    @JvmName("tkqlfllhusepimpk")
    public suspend fun dnsSubscription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSubscription = mapped
    }

    /**
     * @param value File blocking profile data
     */
    @JvmName("spjpmirxiofcowad")
    public suspend fun fileBlockingProfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileBlockingProfile = mapped
    }

    /**
     * @param value Trusted Egress Decryption profile data
     */
    @JvmName("onmsqsbxhcdfqesq")
    public suspend fun outboundTrustCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundTrustCertificate = mapped
    }

    /**
     * @param value Untrusted Egress Decryption profile data
     */
    @JvmName("ougybmguakrkorwy")
    public suspend fun outboundUnTrustCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundUnTrustCertificate = mapped
    }

    /**
     * @param value URL filtering profile data
     */
    @JvmName("xuceweovlvyjbdyu")
    public suspend fun urlFilteringProfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.urlFilteringProfile = mapped
    }

    /**
     * @param value IPs Vulnerability Profile Data
     */
    @JvmName("fyseiowmmanvakdq")
    public suspend fun vulnerabilityProfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vulnerabilityProfile = mapped
    }

    internal fun build(): SecurityServicesArgs = SecurityServicesArgs(
        antiSpywareProfile = antiSpywareProfile,
        antiVirusProfile = antiVirusProfile,
        dnsSubscription = dnsSubscription,
        fileBlockingProfile = fileBlockingProfile,
        outboundTrustCertificate = outboundTrustCertificate,
        outboundUnTrustCertificate = outboundUnTrustCertificate,
        urlFilteringProfile = urlFilteringProfile,
        vulnerabilityProfile = vulnerabilityProfile,
    )
}
