@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.SourceAddrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Address properties
 * @property cidrs special value 'any'
 * @property countries list of countries
 * @property feeds list of feeds
 * @property prefixLists prefix list
 */
public data class SourceAddrArgs(
    public val cidrs: Output<List<String>>? = null,
    public val countries: Output<List<String>>? = null,
    public val feeds: Output<List<String>>? = null,
    public val prefixLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.SourceAddrArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.SourceAddrArgs =
        com.pulumi.azurenative.cloudngfw.inputs.SourceAddrArgs.builder()
            .cidrs(cidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .countries(countries?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .feeds(feeds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .prefixLists(prefixLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SourceAddrArgs].
 */
@PulumiTagMarker
public class SourceAddrArgsBuilder internal constructor() {
    private var cidrs: Output<List<String>>? = null

    private var countries: Output<List<String>>? = null

    private var feeds: Output<List<String>>? = null

    private var prefixLists: Output<List<String>>? = null

    /**
     * @param value special value 'any'
     */
    @JvmName("ddgnyyargesbjgpt")
    public suspend fun cidrs(`value`: Output<List<String>>) {
        this.cidrs = value
    }

    @JvmName("liuuaefmlrifbpye")
    public suspend fun cidrs(vararg values: Output<String>) {
        this.cidrs = Output.all(values.asList())
    }

    /**
     * @param values special value 'any'
     */
    @JvmName("cmcwxboltoqyxmva")
    public suspend fun cidrs(values: List<Output<String>>) {
        this.cidrs = Output.all(values)
    }

    /**
     * @param value list of countries
     */
    @JvmName("wgvbxcukyukbtelc")
    public suspend fun countries(`value`: Output<List<String>>) {
        this.countries = value
    }

    @JvmName("niplanchovxlsjtw")
    public suspend fun countries(vararg values: Output<String>) {
        this.countries = Output.all(values.asList())
    }

    /**
     * @param values list of countries
     */
    @JvmName("qhhhctrpkiiwoghb")
    public suspend fun countries(values: List<Output<String>>) {
        this.countries = Output.all(values)
    }

    /**
     * @param value list of feeds
     */
    @JvmName("ttyfynflqigwxasy")
    public suspend fun feeds(`value`: Output<List<String>>) {
        this.feeds = value
    }

    @JvmName("myfeeuulwuyooexq")
    public suspend fun feeds(vararg values: Output<String>) {
        this.feeds = Output.all(values.asList())
    }

    /**
     * @param values list of feeds
     */
    @JvmName("sfpqxfgnqxkdvjgk")
    public suspend fun feeds(values: List<Output<String>>) {
        this.feeds = Output.all(values)
    }

    /**
     * @param value prefix list
     */
    @JvmName("iikkwnhnogjyklpq")
    public suspend fun prefixLists(`value`: Output<List<String>>) {
        this.prefixLists = value
    }

    @JvmName("mccilgeobowjinmj")
    public suspend fun prefixLists(vararg values: Output<String>) {
        this.prefixLists = Output.all(values.asList())
    }

    /**
     * @param values prefix list
     */
    @JvmName("drgknfqomwvesumi")
    public suspend fun prefixLists(values: List<Output<String>>) {
        this.prefixLists = Output.all(values)
    }

    /**
     * @param value special value 'any'
     */
    @JvmName("tqvvcfebamwsbaej")
    public suspend fun cidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrs = mapped
    }

    /**
     * @param values special value 'any'
     */
    @JvmName("qvaltxdrctjenilp")
    public suspend fun cidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrs = mapped
    }

    /**
     * @param value list of countries
     */
    @JvmName("soyonhfksboqjdrs")
    public suspend fun countries(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countries = mapped
    }

    /**
     * @param values list of countries
     */
    @JvmName("hteuwvjxwgcjmsva")
    public suspend fun countries(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countries = mapped
    }

    /**
     * @param value list of feeds
     */
    @JvmName("epnqjumjpwqqrbyn")
    public suspend fun feeds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.feeds = mapped
    }

    /**
     * @param values list of feeds
     */
    @JvmName("xllqlyxlxlegrppg")
    public suspend fun feeds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.feeds = mapped
    }

    /**
     * @param value prefix list
     */
    @JvmName("akhtbdqgldldptre")
    public suspend fun prefixLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixLists = mapped
    }

    /**
     * @param values prefix list
     */
    @JvmName("xhfjxpvuynmtllng")
    public suspend fun prefixLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixLists = mapped
    }

    internal fun build(): SourceAddrArgs = SourceAddrArgs(
        cidrs = cidrs,
        countries = countries,
        feeds = feeds,
        prefixLists = prefixLists,
    )
}
