@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.inputs

import com.pulumi.azurenative.cloudngfw.inputs.TagInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Tag
 * @property key tag name
 * @property value tag value
 */
public data class TagInfoArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cloudngfw.inputs.TagInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.cloudngfw.inputs.TagInfoArgs =
        com.pulumi.azurenative.cloudngfw.inputs.TagInfoArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagInfoArgs].
 */
@PulumiTagMarker
public class TagInfoArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value tag name
     */
    @JvmName("jigkiryusvuhiqba")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value tag value
     */
    @JvmName("bfmrnfmnougwsdhg")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value tag name
     */
    @JvmName("hbkadixrdvntxoty")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value tag value
     */
    @JvmName("lcwvwiivlxhhpqds")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TagInfoArgs = TagInfoArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
