@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Data Type for App Seen
 * @property appSeenList array of appSeen
 * @property count number of rows
 */
public data class AppSeenDataResponse(
    public val appSeenList: List<AppSeenInfoResponse>,
    public val count: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.AppSeenDataResponse): AppSeenDataResponse = AppSeenDataResponse(
            appSeenList = javaType.appSeenList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.AppSeenInfoResponse.Companion.toKotlin(args0)
                })
            }),
            count = javaType.count(),
        )
    }
}
