@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Definition for App Seen
 * @property category category
 * @property risk risk
 * @property standardPorts standardPorts
 * @property subCategory subCategory
 * @property tag tag
 * @property technology technology
 * @property title title
 */
public data class AppSeenInfoResponse(
    public val category: String,
    public val risk: String,
    public val standardPorts: String,
    public val subCategory: String,
    public val tag: String,
    public val technology: String,
    public val title: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.AppSeenInfoResponse): AppSeenInfoResponse = AppSeenInfoResponse(
            category = javaType.category(),
            risk = javaType.risk(),
            standardPorts = javaType.standardPorts(),
            subCategory = javaType.subCategory(),
            tag = javaType.tag(),
            technology = javaType.technology(),
            title = javaType.title(),
        )
    }
}
