@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Application Insights key
 * @property id Resource id for Application Insights
 * @property key Application Insights key
 */
public data class ApplicationInsightsResponse(
    public val id: String? = null,
    public val key: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.ApplicationInsightsResponse): ApplicationInsightsResponse = ApplicationInsightsResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
        )
    }
}
