@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Country Description
 * @property code country code
 * @property description code description
 */
public data class CountryResponse(
    public val code: String,
    public val description: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.CountryResponse): CountryResponse = CountryResponse(
            code = javaType.code(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
        )
    }
}
