@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * DNS Proxy settings for Firewall
 * @property dnsServers List of IPs associated with the Firewall
 * @property enableDnsProxy Enable DNS proxy, disabled by default
 * @property enabledDnsType Enabled DNS proxy type, disabled by default
 */
public data class DNSSettingsResponse(
    public val dnsServers: List<IPAddressResponse>? = null,
    public val enableDnsProxy: String? = null,
    public val enabledDnsType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.DNSSettingsResponse): DNSSettingsResponse = DNSSettingsResponse(
            dnsServers = javaType.dnsServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.IPAddressResponse.Companion.toKotlin(args0)
                })
            }),
            enableDnsProxy = javaType.enableDnsProxy().map({ args0 -> args0 }).orElse(null),
            enabledDnsType = javaType.enabledDnsType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
