@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Endpoint Configuration for frontend and backend
 * @property address Address Space
 * @property port port ID
 */
public data class EndpointConfigurationResponse(
    public val address: IPAddressResponse,
    public val port: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.EndpointConfigurationResponse): EndpointConfigurationResponse = EndpointConfigurationResponse(
            address = javaType.address().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.IPAddressResponse.Companion.toKotlin(args0)
            }),
            port = javaType.port(),
        )
    }
}
