@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * EventHub configurations
 * @property id Resource ID of EventHub
 * @property name EventHub name
 * @property nameSpace EventHub namespace
 * @property policyName EventHub policy name
 * @property subscriptionId Subscription Id
 */
public data class EventHubResponse(
    public val id: String? = null,
    public val name: String? = null,
    public val nameSpace: String? = null,
    public val policyName: String? = null,
    public val subscriptionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.EventHubResponse): EventHubResponse = EventHubResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            nameSpace = javaType.nameSpace().map({ args0 -> args0 }).orElse(null),
            policyName = javaType.policyName().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
