@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * LocalRulestack Certificate Object
 * @property auditComment comment for this object
 * @property certificateSelfSigned use certificate self signed
 * @property certificateSignerResourceId Resource Id of certificate signer, to be populated only when certificateSelfSigned is false
 * @property description user description for this object
 * @property etag read only string representing last create or update
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetCertificateObjectLocalRulestackResult(
    public val auditComment: String? = null,
    public val certificateSelfSigned: String,
    public val certificateSignerResourceId: String? = null,
    public val description: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.GetCertificateObjectLocalRulestackResult): GetCertificateObjectLocalRulestackResult = GetCertificateObjectLocalRulestackResult(
            auditComment = javaType.auditComment().map({ args0 -> args0 }).orElse(null),
            certificateSelfSigned = javaType.certificateSelfSigned(),
            certificateSignerResourceId = javaType.certificateSignerResourceId().map({ args0 ->
                args0
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
