@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Log Settings for Firewall
 * @property applicationInsights Application Insight details
 * @property commonDestination Common destination configurations
 * @property decryptLogDestination Decrypt destination configurations
 * @property logOption Log option SAME/INDIVIDUAL
 * @property logType One of possible log type
 * @property threatLogDestination Threat destination configurations
 * @property trafficLogDestination Traffic destination configurations
 */
public data class GetFirewallLogProfileResult(
    public val applicationInsights: ApplicationInsightsResponse? = null,
    public val commonDestination: LogDestinationResponse? = null,
    public val decryptLogDestination: LogDestinationResponse? = null,
    public val logOption: String? = null,
    public val logType: String? = null,
    public val threatLogDestination: LogDestinationResponse? = null,
    public val trafficLogDestination: LogDestinationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.GetFirewallLogProfileResult): GetFirewallLogProfileResult = GetFirewallLogProfileResult(
            applicationInsights = javaType.applicationInsights().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.ApplicationInsightsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            commonDestination = javaType.commonDestination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.LogDestinationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            decryptLogDestination = javaType.decryptLogDestination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.LogDestinationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            logOption = javaType.logOption().map({ args0 -> args0 }).orElse(null),
            logType = javaType.logType().map({ args0 -> args0 }).orElse(null),
            threatLogDestination = javaType.threatLogDestination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.LogDestinationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            trafficLogDestination = javaType.trafficLogDestination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.LogDestinationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
