@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * LocalRulestack fqdnList
 * @property auditComment comment for this object
 * @property description fqdn object description
 * @property etag etag info
 * @property fqdnList fqdn list
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetFqdnListLocalRulestackResult(
    public val auditComment: String? = null,
    public val description: String? = null,
    public val etag: String? = null,
    public val fqdnList: List<String>,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.GetFqdnListLocalRulestackResult): GetFqdnListLocalRulestackResult = GetFqdnListLocalRulestackResult(
            auditComment = javaType.auditComment().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            fqdnList = javaType.fqdnList().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
