@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Changelog list
 * @property changes list of changes
 * @property lastCommitted lastCommitted timestamp
 * @property lastModified lastModified timestamp
 */
public data class GetGlobalRulestackChangeLogResult(
    public val changes: List<String>,
    public val lastCommitted: String? = null,
    public val lastModified: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.GetGlobalRulestackChangeLogResult): GetGlobalRulestackChangeLogResult = GetGlobalRulestackChangeLogResult(
            changes = javaType.changes().map({ args0 -> args0 }),
            lastCommitted = javaType.lastCommitted().map({ args0 -> args0 }).orElse(null),
            lastModified = javaType.lastModified().map({ args0 -> args0 }).orElse(null),
        )
    }
}
