@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP Address
 * @property address Address value
 * @property resourceId Resource Id
 */
public data class IPAddressResponse(
    public val address: String? = null,
    public val resourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.IPAddressResponse): IPAddressResponse = IPAddressResponse(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
