@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP Address Space
 * @property addressSpace Address Space
 * @property resourceId Resource Id
 */
public data class IPAddressSpaceResponse(
    public val addressSpace: String? = null,
    public val resourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.IPAddressSpaceResponse): IPAddressSpaceResponse = IPAddressSpaceResponse(
            addressSpace = javaType.addressSpace().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
