@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Product serial and status for the service
 * @property serialNumber product Serial associated with given resource
 * @property status allocation status of the product serial number
 */
public data class ListPaloAltoNetworksCloudngfwProductSerialNumberStatusResult(
    public val serialNumber: String? = null,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.ListPaloAltoNetworksCloudngfwProductSerialNumberStatusResult): ListPaloAltoNetworksCloudngfwProductSerialNumberStatusResult =
            ListPaloAltoNetworksCloudngfwProductSerialNumberStatusResult(
                serialNumber = javaType.serialNumber().map({ args0 -> args0 }).orElse(null),
                status = javaType.status(),
            )
    }
}
