@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.Suppress

/**
 * Log Destination
 * @property eventHubConfigurations Event Hub configurations
 * @property monitorConfigurations Monitor Log configurations
 * @property storageConfigurations Storage account configurations
 */
public data class LogDestinationResponse(
    public val eventHubConfigurations: EventHubResponse? = null,
    public val monitorConfigurations: MonitorLogResponse? = null,
    public val storageConfigurations: StorageAccountResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.LogDestinationResponse): LogDestinationResponse = LogDestinationResponse(
            eventHubConfigurations = javaType.eventHubConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.EventHubResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            monitorConfigurations = javaType.monitorConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.MonitorLogResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageConfigurations = javaType.storageConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.StorageAccountResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
