@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * MonitorLog configurations
 * @property id Resource ID of MonitorLog
 * @property primaryKey Primary Key value for Monitor
 * @property secondaryKey Secondary Key value for Monitor
 * @property subscriptionId Subscription Id
 * @property workspace MonitorLog workspace
 */
public data class MonitorLogResponse(
    public val id: String? = null,
    public val primaryKey: String? = null,
    public val secondaryKey: String? = null,
    public val subscriptionId: String? = null,
    public val workspace: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.MonitorLogResponse): MonitorLogResponse = MonitorLogResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            primaryKey = javaType.primaryKey().map({ args0 -> args0 }).orElse(null),
            secondaryKey = javaType.secondaryKey().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            workspace = javaType.workspace().map({ args0 -> args0 }).orElse(null),
        )
    }
}
