@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * object type info
 * @property description description value
 * @property name name value
 */
public data class NameDescriptionObjectResponse(
    public val description: String? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.NameDescriptionObjectResponse): NameDescriptionObjectResponse = NameDescriptionObjectResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
