@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network settings for Firewall
 * @property egressNatIp Egress nat IP to use
 * @property enableEgressNat Enable egress NAT, enabled by default
 * @property networkType vnet or vwan, cannot be updated
 * @property publicIps List of IPs associated with the Firewall
 * @property trustedRanges Non-RFC 1918 address
 * @property vnetConfiguration Vnet configurations
 * @property vwanConfiguration Vwan configurations
 */
public data class NetworkProfileResponse(
    public val egressNatIp: List<IPAddressResponse>? = null,
    public val enableEgressNat: String,
    public val networkType: String,
    public val publicIps: List<IPAddressResponse>,
    public val trustedRanges: List<String>? = null,
    public val vnetConfiguration: VnetConfigurationResponse? = null,
    public val vwanConfiguration: VwanConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.NetworkProfileResponse): NetworkProfileResponse = NetworkProfileResponse(
            egressNatIp = javaType.egressNatIp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.IPAddressResponse.Companion.toKotlin(args0)
                })
            }),
            enableEgressNat = javaType.enableEgressNat(),
            networkType = javaType.networkType(),
            publicIps = javaType.publicIps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.IPAddressResponse.Companion.toKotlin(args0)
                })
            }),
            trustedRanges = javaType.trustedRanges().map({ args0 -> args0 }),
            vnetConfiguration = javaType.vnetConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.VnetConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vwanConfiguration = javaType.vwanConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.VwanConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
