@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Panorama Config
 * @property cgName Panorama Collector Group to join - (Once configured we can not edit the value)
 * @property configString Base64 encoded string representing Panorama parameters to be used by Firewall to connect to Panorama. This string is generated via azure plugin in Panorama
 * @property dgName Panorama Device Group to join
 * @property hostName Resource name(may be unique) for PN admin
 * @property panoramaServer Primary Panorama Server IP address value in dotted format for IPv4
 * @property panoramaServer2 Secondary Panorama Server IP address value in dotted format for IPv4
 * @property tplName Panorama Template Stack to join - (Once configured we can not edit the value)
 * @property vmAuthKey VM auth key for panorama connectivity
 */
public data class PanoramaConfigResponse(
    public val cgName: String,
    public val configString: String,
    public val dgName: String,
    public val hostName: String,
    public val panoramaServer: String,
    public val panoramaServer2: String,
    public val tplName: String,
    public val vmAuthKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.PanoramaConfigResponse): PanoramaConfigResponse = PanoramaConfigResponse(
            cgName = javaType.cgName(),
            configString = javaType.configString(),
            dgName = javaType.dgName(),
            hostName = javaType.hostName(),
            panoramaServer = javaType.panoramaServer(),
            panoramaServer2 = javaType.panoramaServer2(),
            tplName = javaType.tplName(),
            vmAuthKey = javaType.vmAuthKey(),
        )
    }
}
