@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Associated rulestack details
 * @property location Rulestack location
 * @property resourceId Resource Id
 * @property rulestackId Associated rulestack Id
 */
public data class RulestackDetailsResponse(
    public val location: String? = null,
    public val resourceId: String? = null,
    public val rulestackId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.RulestackDetailsResponse): RulestackDetailsResponse = RulestackDetailsResponse(
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            rulestackId = javaType.rulestackId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
