@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Security services type list
 * @property entry list
 * @property type security services type
 */
public data class SecurityServicesTypeListResponse(
    public val entry: List<NameDescriptionObjectResponse>,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.SecurityServicesTypeListResponse): SecurityServicesTypeListResponse = SecurityServicesTypeListResponse(
            entry = javaType.entry().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.NameDescriptionObjectResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
