@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Address properties
 * @property cidrs special value 'any'
 * @property countries list of countries
 * @property feeds list of feeds
 * @property prefixLists prefix list
 */
public data class SourceAddrResponse(
    public val cidrs: List<String>? = null,
    public val countries: List<String>? = null,
    public val feeds: List<String>? = null,
    public val prefixLists: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.SourceAddrResponse): SourceAddrResponse = SourceAddrResponse(
            cidrs = javaType.cidrs().map({ args0 -> args0 }),
            countries = javaType.countries().map({ args0 -> args0 }),
            feeds = javaType.feeds().map({ args0 -> args0 }),
            prefixLists = javaType.prefixLists().map({ args0 -> args0 }),
        )
    }
}
