@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Storage Account configurations
 * @property accountName Storage account name
 * @property id Resource ID of storage account
 * @property subscriptionId Subscription Id
 */
public data class StorageAccountResponse(
    public val accountName: String? = null,
    public val id: String? = null,
    public val subscriptionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.StorageAccountResponse): StorageAccountResponse = StorageAccountResponse(
            accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
