@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cloudngfw.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VwanInfo for Firewall Networking
 * @property ipOfTrustSubnetForUdr IP of trust subnet for UDR
 * @property networkVirtualApplianceId Network Virtual Appliance resource ID
 * @property trustSubnet Trust Subnet
 * @property unTrustSubnet Untrust Subnet
 * @property vHub vHub Address
 */
public data class VwanConfigurationResponse(
    public val ipOfTrustSubnetForUdr: IPAddressResponse? = null,
    public val networkVirtualApplianceId: String? = null,
    public val trustSubnet: IPAddressSpaceResponse? = null,
    public val unTrustSubnet: IPAddressSpaceResponse? = null,
    public val vHub: IPAddressSpaceResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cloudngfw.outputs.VwanConfigurationResponse): VwanConfigurationResponse = VwanConfigurationResponse(
            ipOfTrustSubnetForUdr = javaType.ipOfTrustSubnetForUdr().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.IPAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            networkVirtualApplianceId = javaType.networkVirtualApplianceId().map({ args0 ->
                args0
            }).orElse(null),
            trustSubnet = javaType.trustSubnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.IPAddressSpaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            unTrustSubnet = javaType.unTrustSubnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.cloudngfw.kotlin.outputs.IPAddressSpaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vHub = javaType.vHub().let({ args0 ->
                com.pulumi.azurenative.cloudngfw.kotlin.outputs.IPAddressSpaceResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
