@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.codesigning.kotlin

import com.pulumi.azurenative.codesigning.CodesigningFunctions.getCertificateProfilePlain
import com.pulumi.azurenative.codesigning.CodesigningFunctions.getCodeSigningAccountPlain
import com.pulumi.azurenative.codesigning.kotlin.inputs.GetCertificateProfilePlainArgs
import com.pulumi.azurenative.codesigning.kotlin.inputs.GetCertificateProfilePlainArgsBuilder
import com.pulumi.azurenative.codesigning.kotlin.inputs.GetCodeSigningAccountPlainArgs
import com.pulumi.azurenative.codesigning.kotlin.inputs.GetCodeSigningAccountPlainArgsBuilder
import com.pulumi.azurenative.codesigning.kotlin.outputs.GetCertificateProfileResult
import com.pulumi.azurenative.codesigning.kotlin.outputs.GetCodeSigningAccountResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.codesigning.kotlin.outputs.GetCertificateProfileResult.Companion.toKotlin as getCertificateProfileResultToKotlin
import com.pulumi.azurenative.codesigning.kotlin.outputs.GetCodeSigningAccountResult.Companion.toKotlin as getCodeSigningAccountResultToKotlin

public object CodesigningFunctions {
    /**
     * Get details of a certificate profile.
     * Azure REST API version: 2024-02-05-preview.
     * @param argument null
     * @return Certificate profile resource.
     */
    public suspend fun getCertificateProfile(argument: GetCertificateProfilePlainArgs): GetCertificateProfileResult =
        getCertificateProfileResultToKotlin(getCertificateProfilePlain(argument.toJava()).await())

    /**
     * @see [getCertificateProfile].
     * @param accountName Trusted Signing account name.
     * @param profileName Certificate profile name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Certificate profile resource.
     */
    public suspend fun getCertificateProfile(
        accountName: String,
        profileName: String,
        resourceGroupName: String,
    ): GetCertificateProfileResult {
        val argument = GetCertificateProfilePlainArgs(
            accountName = accountName,
            profileName = profileName,
            resourceGroupName = resourceGroupName,
        )
        return getCertificateProfileResultToKotlin(getCertificateProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificateProfile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;codesigning&#46;kotlin&#46;inputs&#46;GetCertificateProfilePlainArgs].
     * @return Certificate profile resource.
     */
    public suspend fun getCertificateProfile(argument: suspend GetCertificateProfilePlainArgsBuilder.() -> Unit): GetCertificateProfileResult {
        val builder = GetCertificateProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificateProfileResultToKotlin(getCertificateProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a trusted Signing Account.
     * Azure REST API version: 2024-02-05-preview.
     * @param argument null
     * @return Trusted signing account resource.
     */
    public suspend fun getCodeSigningAccount(argument: GetCodeSigningAccountPlainArgs): GetCodeSigningAccountResult =
        getCodeSigningAccountResultToKotlin(getCodeSigningAccountPlain(argument.toJava()).await())

    /**
     * @see [getCodeSigningAccount].
     * @param accountName Trusted Signing account name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Trusted signing account resource.
     */
    public suspend fun getCodeSigningAccount(accountName: String, resourceGroupName: String): GetCodeSigningAccountResult {
        val argument = GetCodeSigningAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getCodeSigningAccountResultToKotlin(getCodeSigningAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getCodeSigningAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;codesigning&#46;kotlin&#46;inputs&#46;GetCodeSigningAccountPlainArgs].
     * @return Trusted signing account resource.
     */
    public suspend fun getCodeSigningAccount(argument: suspend GetCodeSigningAccountPlainArgsBuilder.() -> Unit): GetCodeSigningAccountResult {
        val builder = GetCodeSigningAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCodeSigningAccountResultToKotlin(getCodeSigningAccountPlain(builtArgument.toJava()).await())
    }
}
