@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.codesigning.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Profile type of the certificate.
 */
public enum class ProfileType(
    public val javaValue: com.pulumi.azurenative.codesigning.enums.ProfileType,
) : ConvertibleToJava<com.pulumi.azurenative.codesigning.enums.ProfileType> {
    /**
     * Used for signing files which are distributed publicly.
     */
    PublicTrust(com.pulumi.azurenative.codesigning.enums.ProfileType.PublicTrust),

    /**
     * Used for signing files which are distributed internally within organization or group boundary.
     */
    PrivateTrust(com.pulumi.azurenative.codesigning.enums.ProfileType.PrivateTrust),

    /**
     * Used for signing CI policy files.
     */
    PrivateTrustCIPolicy(com.pulumi.azurenative.codesigning.enums.ProfileType.PrivateTrustCIPolicy),

    /**
     * Used for signing files which are run in secure vbs enclave.
     */
    VBSEnclave(com.pulumi.azurenative.codesigning.enums.ProfileType.VBSEnclave),

    /**
     * Used for signing files for testing purpose.
     */
    PublicTrustTest(com.pulumi.azurenative.codesigning.enums.ProfileType.PublicTrustTest),
    ;

    override fun toJava(): com.pulumi.azurenative.codesigning.enums.ProfileType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.codesigning.enums.ProfileType): ProfileType = ProfileType.values().first { it.javaValue == javaType }
    }
}
