@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.codesigning.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Name of the SKU.
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.codesigning.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.codesigning.enums.SkuName> {
    /**
     * Basic sku.
     */
    Basic(com.pulumi.azurenative.codesigning.enums.SkuName.Basic),

    /**
     * Premium sku.
     */
    Premium(com.pulumi.azurenative.codesigning.enums.SkuName.Premium),
    ;

    override fun toJava(): com.pulumi.azurenative.codesigning.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.codesigning.enums.SkuName): SkuName =
            SkuName.values().first { it.javaValue == javaType }
    }
}
