@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.codesigning.kotlin.inputs

import com.pulumi.azurenative.codesigning.inputs.GetCodeSigningAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Trusted Signing account name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCodeSigningAccountPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.codesigning.inputs.GetCodeSigningAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.codesigning.inputs.GetCodeSigningAccountPlainArgs =
        com.pulumi.azurenative.codesigning.inputs.GetCodeSigningAccountPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCodeSigningAccountPlainArgs].
 */
@PulumiTagMarker
public class GetCodeSigningAccountPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Trusted Signing account name.
     */
    @JvmName("ekvyaqpuspirtnci")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yweeacvntimkgtvk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCodeSigningAccountPlainArgs = GetCodeSigningAccountPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
