@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.codesigning.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Certificate profile resource.
 * @property city Used as L in the certificate subject name.
 * @property commonName Used as CN in the certificate subject name.
 * @property country Used as C in the certificate subject name.
 * @property enhancedKeyUsage Enhanced key usage of the certificate.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property identityValidationId Identity validation id used for the certificate subject name.
 * @property includeCity Whether to include L in the certificate subject name. Applicable only for private trust, private trust ci profile types
 * @property includeCountry Whether to include C in the certificate subject name. Applicable only for private trust, private trust ci profile types
 * @property includePostalCode Whether to include PC in the certificate subject name.
 * @property includeState Whether to include S in the certificate subject name. Applicable only for private trust, private trust ci profile types
 * @property includeStreetAddress Whether to include STREET in the certificate subject name.
 * @property name The name of the resource
 * @property organization Used as O in the certificate subject name.
 * @property organizationUnit Used as OU in the private trust certificate subject name.
 * @property postalCode Used as PC in the certificate subject name.
 * @property profileType Profile type of the certificate.
 * @property provisioningState Status of the current operation on certificate profile.
 * @property state Used as S in the certificate subject name.
 * @property status Status of the certificate profile.
 * @property streetAddress Used as STREET in the certificate subject name.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetCertificateProfileResult(
    public val city: String,
    public val commonName: String,
    public val country: String,
    public val enhancedKeyUsage: String,
    public val id: String,
    public val identityValidationId: String? = null,
    public val includeCity: Boolean? = null,
    public val includeCountry: Boolean? = null,
    public val includePostalCode: Boolean? = null,
    public val includeState: Boolean? = null,
    public val includeStreetAddress: Boolean? = null,
    public val name: String,
    public val organization: String,
    public val organizationUnit: String,
    public val postalCode: String,
    public val profileType: String,
    public val provisioningState: String,
    public val state: String,
    public val status: String,
    public val streetAddress: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.codesigning.outputs.GetCertificateProfileResult): GetCertificateProfileResult = GetCertificateProfileResult(
            city = javaType.city(),
            commonName = javaType.commonName(),
            country = javaType.country(),
            enhancedKeyUsage = javaType.enhancedKeyUsage(),
            id = javaType.id(),
            identityValidationId = javaType.identityValidationId().map({ args0 -> args0 }).orElse(null),
            includeCity = javaType.includeCity().map({ args0 -> args0 }).orElse(null),
            includeCountry = javaType.includeCountry().map({ args0 -> args0 }).orElse(null),
            includePostalCode = javaType.includePostalCode().map({ args0 -> args0 }).orElse(null),
            includeState = javaType.includeState().map({ args0 -> args0 }).orElse(null),
            includeStreetAddress = javaType.includeStreetAddress().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            organization = javaType.organization(),
            organizationUnit = javaType.organizationUnit(),
            postalCode = javaType.postalCode(),
            profileType = javaType.profileType(),
            provisioningState = javaType.provisioningState(),
            state = javaType.state(),
            status = javaType.status(),
            streetAddress = javaType.streetAddress(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.codesigning.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
