@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.AccountArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.AccountPropertiesArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.AccountPropertiesArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Cognitive Services account is an Azure resource representing the provisioned account, it's type, location and SKU.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2017-04-18.
 * Other available API versions: 2017-04-18, 2023-10-01-preview, 2024-04-01-preview.
 * ## Example Usage
 * ### Create Account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.CognitiveServices.Account("account", new()
 *     {
 *         AccountName = "testCreate1",
 *         Identity = new AzureNative.CognitiveServices.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.CognitiveServices.ResourceIdentityType.SystemAssigned,
 *         },
 *         Kind = "Emotion",
 *         Location = "West US",
 *         Properties = new AzureNative.CognitiveServices.Inputs.AccountPropertiesArgs
 *         {
 *             Encryption = new AzureNative.CognitiveServices.Inputs.EncryptionArgs
 *             {
 *                 KeySource = AzureNative.CognitiveServices.KeySource.Microsoft_KeyVault,
 *                 KeyVaultProperties = new AzureNative.CognitiveServices.Inputs.KeyVaultPropertiesArgs
 *                 {
 *                     KeyName = "KeyName",
 *                     KeyVaultUri = "https://pltfrmscrts-use-pc-dev.vault.azure.net/",
 *                     KeyVersion = "891CF236-D241-4738-9462-D506AF493DFA",
 *                 },
 *             },
 *             UserOwnedStorage = new[]
 *             {
 *                 new AzureNative.CognitiveServices.Inputs.UserOwnedStorageArgs
 *                 {
 *                     ResourceId = "/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.CognitiveServices.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewAccount(ctx, "account", &cognitiveservices.AccountArgs{
 * 			AccountName: pulumi.String("testCreate1"),
 * 			Identity: &cognitiveservices.IdentityArgs{
 * 				Type: cognitiveservices.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Kind:     pulumi.String("Emotion"),
 * 			Location: pulumi.String("West US"),
 * 			Properties: &cognitiveservices.AccountPropertiesArgs{
 * 				Encryption: &cognitiveservices.EncryptionArgs{
 * 					KeySource: pulumi.String(cognitiveservices.KeySource_Microsoft_KeyVault),
 * 					KeyVaultProperties: &cognitiveservices.KeyVaultPropertiesArgs{
 * 						KeyName:     pulumi.String("KeyName"),
 * 						KeyVaultUri: pulumi.String("https://pltfrmscrts-use-pc-dev.vault.azure.net/"),
 * 						KeyVersion:  pulumi.String("891CF236-D241-4738-9462-D506AF493DFA"),
 * 					},
 * 				},
 * 				UserOwnedStorage: cognitiveservices.UserOwnedStorageArray{
 * 					&cognitiveservices.UserOwnedStorageArgs{
 * 						ResourceId: pulumi.String("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &cognitiveservices.SkuArgs{
 * 				Name: pulumi.String("S0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.Account;
 * import com.pulumi.azurenative.cognitiveservices.AccountArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.IdentityArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.AccountPropertiesArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.KeyVaultPropertiesArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("testCreate1")
 *             .identity(IdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .kind("Emotion")
 *             .location("West US")
 *             .properties(AccountPropertiesArgs.builder()
 *                 .encryption(EncryptionArgs.builder()
 *                     .keySource("Microsoft.KeyVault")
 *                     .keyVaultProperties(KeyVaultPropertiesArgs.builder()
 *                         .keyName("KeyName")
 *                         .keyVaultUri("https://pltfrmscrts-use-pc-dev.vault.azure.net/")
 *                         .keyVersion("891CF236-D241-4738-9462-D506AF493DFA")
 *                         .build())
 *                     .build())
 *                 .userOwnedStorage(UserOwnedStorageArgs.builder()
 *                     .resourceId("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("S0")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create Account Min
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.CognitiveServices.Account("account", new()
 *     {
 *         AccountName = "testCreate1",
 *         Identity = new AzureNative.CognitiveServices.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.CognitiveServices.ResourceIdentityType.SystemAssigned,
 *         },
 *         Kind = "CognitiveServices",
 *         Location = "West US",
 *         Properties = null,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.CognitiveServices.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewAccount(ctx, "account", &cognitiveservices.AccountArgs{
 * 			AccountName: pulumi.String("testCreate1"),
 * 			Identity: &cognitiveservices.IdentityArgs{
 * 				Type: cognitiveservices.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Kind:              pulumi.String("CognitiveServices"),
 * 			Location:          pulumi.String("West US"),
 * 			Properties:        nil,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &cognitiveservices.SkuArgs{
 * 				Name: pulumi.String("S0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.Account;
 * import com.pulumi.azurenative.cognitiveservices.AccountArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.IdentityArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.AccountPropertiesArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("testCreate1")
 *             .identity(IdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .kind("CognitiveServices")
 *             .location("West US")
 *             .properties()
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("S0")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:Account testCreate1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}
 * ```
 * @property accountName The name of Cognitive Services account.
 * @property identity Identity for the resource.
 * @property kind The Kind of the resource.
 * @property location The geo-location where the resource lives
 * @property properties Properties of Cognitive Services account.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The resource model definition representing SKU
 * @property tags Resource tags.
 */
public data class AccountArgs(
    public val accountName: Output<String>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<AccountPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.AccountArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.AccountArgs =
        com.pulumi.azurenative.cognitiveservices.AccountArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AccountArgs].
 */
@PulumiTagMarker
public class AccountArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var identity: Output<IdentityArgs>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<AccountPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("wgncvnvqtluxatuc")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("qpjcplubhomixhew")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The Kind of the resource.
     */
    @JvmName("vgjddhshsvppghyq")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ddcuttohhqlkmnpq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of Cognitive Services account.
     */
    @JvmName("dhelecfrjntjuuop")
    public suspend fun properties(`value`: Output<AccountPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wccsunlaiysxrqqg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource model definition representing SKU
     */
    @JvmName("gmxhdytslaqtiaph")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vvwbxahuhpndpbtj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("jawphcxcmkdhkare")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("smbwhlotttmixihd")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("trafofkvgyyejdev")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The Kind of the resource.
     */
    @JvmName("cgbaxpxdijwjmbno")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hbijiduhaxxhbeuh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of Cognitive Services account.
     */
    @JvmName("kywmcvvjdafjuxcm")
    public suspend fun properties(`value`: AccountPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Cognitive Services account.
     */
    @JvmName("hlvhboxywjwswsoe")
    public suspend fun properties(argument: suspend AccountPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AccountPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cjjtvbbcjfgjuitk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource model definition representing SKU
     */
    @JvmName("dsmlehihmiaawgut")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The resource model definition representing SKU
     */
    @JvmName("lruruhlqdeiykbwh")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("peipmaqjcxvloyee")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tqwmgluoggtstkaa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AccountArgs = AccountArgs(
        accountName = accountName,
        identity = identity,
        kind = kind,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
