@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.CommitmentPlanPropertiesResponse
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.CommitmentPlanPropertiesResponse.Companion.toKotlin as commitmentPlanPropertiesResponseToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CommitmentPlan].
 */
@PulumiTagMarker
public class CommitmentPlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CommitmentPlanArgs = CommitmentPlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CommitmentPlanArgsBuilder.() -> Unit) {
        val builder = CommitmentPlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CommitmentPlan {
        val builtJavaResource =
            com.pulumi.azurenative.cognitiveservices.CommitmentPlan(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CommitmentPlan(builtJavaResource)
    }
}

/**
 * Cognitive Services account commitment plan.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-10-01.
 * Other available API versions: 2023-10-01-preview, 2024-04-01-preview.
 * ## Example Usage
 * ### PutCommitmentPlan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var commitmentPlan = new AzureNative.CognitiveServices.CommitmentPlan("commitmentPlan", new()
 *     {
 *         AccountName = "accountName",
 *         CommitmentPlanName = "commitmentPlanName",
 *         Properties = new AzureNative.CognitiveServices.Inputs.CommitmentPlanPropertiesArgs
 *         {
 *             AutoRenew = true,
 *             Current = new AzureNative.CognitiveServices.Inputs.CommitmentPeriodArgs
 *             {
 *                 Tier = "T1",
 *             },
 *             HostingModel = AzureNative.CognitiveServices.HostingModel.Web,
 *             PlanType = "Speech2Text",
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewCommitmentPlan(ctx, "commitmentPlan", &cognitiveservices.CommitmentPlanArgs{
 * 			AccountName:        pulumi.String("accountName"),
 * 			CommitmentPlanName: pulumi.String("commitmentPlanName"),
 * 			Properties: &cognitiveservices.CommitmentPlanPropertiesArgs{
 * 				AutoRenew: pulumi.Bool(true),
 * 				Current: &cognitiveservices.CommitmentPeriodArgs{
 * 					Tier: pulumi.String("T1"),
 * 				},
 * 				HostingModel: pulumi.String(cognitiveservices.HostingModelWeb),
 * 				PlanType:     pulumi.String("Speech2Text"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.CommitmentPlan;
 * import com.pulumi.azurenative.cognitiveservices.CommitmentPlanArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPlanPropertiesArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.CommitmentPeriodArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var commitmentPlan = new CommitmentPlan("commitmentPlan", CommitmentPlanArgs.builder()
 *             .accountName("accountName")
 *             .commitmentPlanName("commitmentPlanName")
 *             .properties(CommitmentPlanPropertiesArgs.builder()
 *                 .autoRenew(true)
 *                 .current(CommitmentPeriodArgs.builder()
 *                     .tier("T1")
 *                     .build())
 *                 .hostingModel("Web")
 *                 .planType("Speech2Text")
 *                 .build())
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:CommitmentPlan commitmentPlanName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/commitmentPlans/{commitmentPlanName}
 * ```
 */
public class CommitmentPlan internal constructor(
    override val javaResource: com.pulumi.azurenative.cognitiveservices.CommitmentPlan,
) : KotlinCustomResource(javaResource, CommitmentPlanMapper) {
    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The Kind of the resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of Cognitive Services account commitment plan.
     */
    public val properties: Output<CommitmentPlanPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                commitmentPlanPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The resource model definition representing SKU
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CommitmentPlanMapper : ResourceMapper<CommitmentPlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cognitiveservices.CommitmentPlan::class == javaResource::class

    override fun map(javaResource: Resource): CommitmentPlan = CommitmentPlan(
        javaResource as
            com.pulumi.azurenative.cognitiveservices.CommitmentPlan,
    )
}

/**
 * @see [CommitmentPlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CommitmentPlan].
 */
public suspend fun commitmentPlan(
    name: String,
    block: suspend CommitmentPlanResourceBuilder.() -> Unit,
): CommitmentPlan {
    val builder = CommitmentPlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CommitmentPlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun commitmentPlan(name: String): CommitmentPlan {
    val builder = CommitmentPlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
