@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CommitmentPlanAssociation].
 */
@PulumiTagMarker
public class CommitmentPlanAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CommitmentPlanAssociationArgs = CommitmentPlanAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CommitmentPlanAssociationArgsBuilder.() -> Unit) {
        val builder = CommitmentPlanAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CommitmentPlanAssociation {
        val builtJavaResource =
            com.pulumi.azurenative.cognitiveservices.CommitmentPlanAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CommitmentPlanAssociation(builtJavaResource)
    }
}

/**
 * The commitment plan association.
 * Azure REST API version: 2023-05-01.
 * Other available API versions: 2023-10-01-preview, 2024-04-01-preview.
 * ## Example Usage
 * ### PutCommitmentPlan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var commitmentPlanAssociation = new AzureNative.CognitiveServices.CommitmentPlanAssociation("commitmentPlanAssociation", new()
 *     {
 *         AccountId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.CognitiveServices/accounts/accountName",
 *         CommitmentPlanAssociationName = "commitmentPlanAssociationName",
 *         CommitmentPlanName = "commitmentPlanName",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewCommitmentPlanAssociation(ctx, "commitmentPlanAssociation", &cognitiveservices.CommitmentPlanAssociationArgs{
 * 			AccountId:                     pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.CognitiveServices/accounts/accountName"),
 * 			CommitmentPlanAssociationName: pulumi.String("commitmentPlanAssociationName"),
 * 			CommitmentPlanName:            pulumi.String("commitmentPlanName"),
 * 			ResourceGroupName:             pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.CommitmentPlanAssociation;
 * import com.pulumi.azurenative.cognitiveservices.CommitmentPlanAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var commitmentPlanAssociation = new CommitmentPlanAssociation("commitmentPlanAssociation", CommitmentPlanAssociationArgs.builder()
 *             .accountId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.CognitiveServices/accounts/accountName")
 *             .commitmentPlanAssociationName("commitmentPlanAssociationName")
 *             .commitmentPlanName("commitmentPlanName")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:CommitmentPlanAssociation commitmentPlanAssociationName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/commitmentPlans/{commitmentPlanName}/accountAssociations/{commitmentPlanAssociationName}
 * ```
 */
public class CommitmentPlanAssociation internal constructor(
    override val javaResource: com.pulumi.azurenative.cognitiveservices.CommitmentPlanAssociation,
) : KotlinCustomResource(javaResource, CommitmentPlanAssociationMapper) {
    /**
     * The Azure resource id of the account.
     */
    public val accountId: Output<String>?
        get() = javaResource.accountId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CommitmentPlanAssociationMapper : ResourceMapper<CommitmentPlanAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cognitiveservices.CommitmentPlanAssociation::class == javaResource::class

    override fun map(javaResource: Resource): CommitmentPlanAssociation =
        CommitmentPlanAssociation(
            javaResource as
                com.pulumi.azurenative.cognitiveservices.CommitmentPlanAssociation,
        )
}

/**
 * @see [CommitmentPlanAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CommitmentPlanAssociation].
 */
public suspend fun commitmentPlanAssociation(
    name: String,
    block: suspend CommitmentPlanAssociationResourceBuilder.() -> Unit,
): CommitmentPlanAssociation {
    val builder = CommitmentPlanAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CommitmentPlanAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun commitmentPlanAssociation(name: String): CommitmentPlanAssociation {
    val builder = CommitmentPlanAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
