@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.PrivateEndpointConnectionPropertiesArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.PrivateEndpointConnectionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2017-04-18.
 * Other available API versions: 2023-10-01-preview, 2024-04-01-preview.
 * ## Example Usage
 * ### PutPrivateEndpointConnection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.CognitiveServices.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         AccountName = "sto9699",
 *         PrivateEndpointConnectionName = "{privateEndpointConnectionName}",
 *         Properties = new AzureNative.CognitiveServices.Inputs.PrivateEndpointConnectionPropertiesArgs
 *         {
 *             PrivateLinkServiceConnectionState = new AzureNative.CognitiveServices.Inputs.PrivateLinkServiceConnectionStateArgs
 *             {
 *                 Description = "Auto-Approved",
 *                 Status = AzureNative.CognitiveServices.PrivateEndpointServiceConnectionStatus.Approved,
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &cognitiveservices.PrivateEndpointConnectionArgs{
 * 			AccountName:                   pulumi.String("sto9699"),
 * 			PrivateEndpointConnectionName: pulumi.String("{privateEndpointConnectionName}"),
 * 			Properties: &cognitiveservices.PrivateEndpointConnectionPropertiesArgs{
 * 				PrivateLinkServiceConnectionState: &cognitiveservices.PrivateLinkServiceConnectionStateArgs{
 * 					Description: pulumi.String("Auto-Approved"),
 * 					Status:      pulumi.String(cognitiveservices.PrivateEndpointServiceConnectionStatusApproved),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res7687"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.PrivateEndpointConnection;
 * import com.pulumi.azurenative.cognitiveservices.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.PrivateEndpointConnectionPropertiesArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .accountName("sto9699")
 *             .privateEndpointConnectionName("{privateEndpointConnectionName}")
 *             .properties(PrivateEndpointConnectionPropertiesArgs.builder()
 *                 .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                     .description("Auto-Approved")
 *                     .status("Approved")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:PrivateEndpointConnection {privateEndpointConnectionName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property accountName The name of Cognitive Services account.
 * @property location The location of the private endpoint connection
 * @property privateEndpointConnectionName The name of the private endpoint connection associated with the Cognitive Services Account
 * @property properties Resource properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class PrivateEndpointConnectionArgs(
    public val accountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val properties: Output<PrivateEndpointConnectionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.cognitiveservices.PrivateEndpointConnectionArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var location: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var properties: Output<PrivateEndpointConnectionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("jxkfihiurundpxxf")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The location of the private endpoint connection
     */
    @JvmName("xfnnwbeaixtdinqc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the private endpoint connection associated with the Cognitive Services Account
     */
    @JvmName("jlsgfxwoyaekplwe")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Resource properties.
     */
    @JvmName("jlwpfusjrussbija")
    public suspend fun properties(`value`: Output<PrivateEndpointConnectionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hwqthkkwgsatuyvx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("npysyomwnvjuyess")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The location of the private endpoint connection
     */
    @JvmName("wdrfgnmpemjrmysy")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the private endpoint connection associated with the Cognitive Services Account
     */
    @JvmName("vjdomxjxdjwkhrrk")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Resource properties.
     */
    @JvmName("jnkirricwwlirwwu")
    public suspend fun properties(`value`: PrivateEndpointConnectionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Resource properties.
     */
    @JvmName("pkdywbmpfocbxbji")
    public suspend fun properties(argument: suspend PrivateEndpointConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointConnectionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rnhttdcnlrrsycyj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        accountName = accountName,
        location = location,
        privateEndpointConnectionName = privateEndpointConnectionName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
