@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.RaiPolicyPropertiesResponse
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.RaiPolicyPropertiesResponse.Companion.toKotlin as raiPolicyPropertiesResponseToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RaiPolicy].
 */
@PulumiTagMarker
public class RaiPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RaiPolicyArgs = RaiPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RaiPolicyArgsBuilder.() -> Unit) {
        val builder = RaiPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RaiPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.cognitiveservices.RaiPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RaiPolicy(builtJavaResource)
    }
}

/**
 * Cognitive Services RaiPolicy.
 * Azure REST API version: 2023-10-01-preview.
 * Other available API versions: 2024-04-01-preview.
 * ## Example Usage
 * ### PutRaiPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var raiPolicy = new AzureNative.CognitiveServices.RaiPolicy("raiPolicy", new()
 *     {
 *         AccountName = "accountName",
 *         Properties = new AzureNative.CognitiveServices.Inputs.RaiPolicyPropertiesArgs
 *         {
 *             BasePolicyName = "112",
 *             ContentFilters = new[]
 *             {
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.High,
 *                     Blocking = false,
 *                     Enabled = false,
 *                     Name = "hate",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Prompt,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.Medium,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "hate",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.High,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "sexual",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Prompt,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.Medium,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "sexual",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.High,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "selfharm",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Prompt,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.Medium,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "selfharm",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.Medium,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "violence",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Prompt,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.Medium,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "violence",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "jailbreak",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Prompt,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "protected_material_text",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "protected_material_code",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "profanity",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Prompt,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "profanity",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *             },
 *         },
 *         RaiPolicyName = "raiPolicyName",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewRaiPolicy(ctx, "raiPolicy", &cognitiveservices.RaiPolicyArgs{
 * 			AccountName: pulumi.String("accountName"),
 * 			Properties: &cognitiveservices.RaiPolicyPropertiesArgs{
 * 				BasePolicyName: pulumi.String("112"),
 * 				ContentFilters: cognitiveservices.RaiPolicyContentFilterArray{
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelHigh),
 * 						Blocking:            pulumi.Bool(false),
 * 						Enabled:             pulumi.Bool(false),
 * 						Name:                pulumi.String("hate"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelMedium),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("hate"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelHigh),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("sexual"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelMedium),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("sexual"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelHigh),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("selfharm"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelMedium),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("selfharm"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelMedium),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("violence"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelMedium),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("violence"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						Blocking: pulumi.Bool(true),
 * 						Enabled:  pulumi.Bool(true),
 * 						Name:     pulumi.String("jailbreak"),
 * 						Source:   pulumi.String(cognitiveservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						Blocking: pulumi.Bool(true),
 * 						Enabled:  pulumi.Bool(true),
 * 						Name:     pulumi.String("protected_material_text"),
 * 						Source:   pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						Blocking: pulumi.Bool(true),
 * 						Enabled:  pulumi.Bool(true),
 * 						Name:     pulumi.String("protected_material_code"),
 * 						Source:   pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						Blocking: pulumi.Bool(true),
 * 						Enabled:  pulumi.Bool(true),
 * 						Name:     pulumi.String("profanity"),
 * 						Source:   pulumi.String(cognitiveservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						Blocking: pulumi.Bool(true),
 * 						Enabled:  pulumi.Bool(true),
 * 						Name:     pulumi.String("profanity"),
 * 						Source:   pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 				},
 * 			},
 * 			RaiPolicyName:     pulumi.String("raiPolicyName"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.RaiPolicy;
 * import com.pulumi.azurenative.cognitiveservices.RaiPolicyArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var raiPolicy = new RaiPolicy("raiPolicy", RaiPolicyArgs.builder()
 *             .accountName("accountName")
 *             .properties(RaiPolicyPropertiesArgs.builder()
 *                 .basePolicyName("112")
 *                 .contentFilters(
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("High")
 *                         .blocking(false)
 *                         .enabled(false)
 *                         .name("hate")
 *                         .source("Prompt")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("Medium")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("hate")
 *                         .source("Completion")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("High")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("sexual")
 *                         .source("Prompt")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("Medium")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("sexual")
 *                         .source("Completion")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("High")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("selfharm")
 *                         .source("Prompt")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("Medium")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("selfharm")
 *                         .source("Completion")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("Medium")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("violence")
 *                         .source("Prompt")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("Medium")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("violence")
 *                         .source("Completion")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("jailbreak")
 *                         .source("Prompt")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("protected_material_text")
 *                         .source("Completion")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("protected_material_code")
 *                         .source("Completion")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("profanity")
 *                         .source("Prompt")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("profanity")
 *                         .source("Completion")
 *                         .build())
 *                 .build())
 *             .raiPolicyName("raiPolicyName")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:RaiPolicy raiPolicyName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/raiPolicies/{raiPolicyName}
 * ```
 */
public class RaiPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.cognitiveservices.RaiPolicy,
) : KotlinCustomResource(javaResource, RaiPolicyMapper) {
    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of Cognitive Services RaiPolicy.
     */
    public val properties: Output<RaiPolicyPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                raiPolicyPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RaiPolicyMapper : ResourceMapper<RaiPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cognitiveservices.RaiPolicy::class == javaResource::class

    override fun map(javaResource: Resource): RaiPolicy = RaiPolicy(
        javaResource as
            com.pulumi.azurenative.cognitiveservices.RaiPolicy,
    )
}

/**
 * @see [RaiPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RaiPolicy].
 */
public suspend fun raiPolicy(name: String, block: suspend RaiPolicyResourceBuilder.() -> Unit): RaiPolicy {
    val builder = RaiPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RaiPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun raiPolicy(name: String): RaiPolicy {
    val builder = RaiPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
