@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.RaiPolicyArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.RaiPolicyPropertiesArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.RaiPolicyPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Cognitive Services RaiPolicy.
 * Azure REST API version: 2023-10-01-preview.
 * Other available API versions: 2024-04-01-preview.
 * ## Example Usage
 * ### PutRaiPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var raiPolicy = new AzureNative.CognitiveServices.RaiPolicy("raiPolicy", new()
 *     {
 *         AccountName = "accountName",
 *         Properties = new AzureNative.CognitiveServices.Inputs.RaiPolicyPropertiesArgs
 *         {
 *             BasePolicyName = "112",
 *             ContentFilters = new[]
 *             {
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.High,
 *                     Blocking = false,
 *                     Enabled = false,
 *                     Name = "hate",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Prompt,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.Medium,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "hate",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.High,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "sexual",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Prompt,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.Medium,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "sexual",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.High,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "selfharm",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Prompt,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.Medium,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "selfharm",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.Medium,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "violence",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Prompt,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     AllowedContentLevel = AzureNative.CognitiveServices.AllowedContentLevel.Medium,
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "violence",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "jailbreak",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Prompt,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "protected_material_text",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "protected_material_code",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "profanity",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Prompt,
 *                 },
 *                 new AzureNative.CognitiveServices.Inputs.RaiPolicyContentFilterArgs
 *                 {
 *                     Blocking = true,
 *                     Enabled = true,
 *                     Name = "profanity",
 *                     Source = AzureNative.CognitiveServices.RaiPolicyContentSource.Completion,
 *                 },
 *             },
 *         },
 *         RaiPolicyName = "raiPolicyName",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewRaiPolicy(ctx, "raiPolicy", &cognitiveservices.RaiPolicyArgs{
 * 			AccountName: pulumi.String("accountName"),
 * 			Properties: &cognitiveservices.RaiPolicyPropertiesArgs{
 * 				BasePolicyName: pulumi.String("112"),
 * 				ContentFilters: cognitiveservices.RaiPolicyContentFilterArray{
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelHigh),
 * 						Blocking:            pulumi.Bool(false),
 * 						Enabled:             pulumi.Bool(false),
 * 						Name:                pulumi.String("hate"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelMedium),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("hate"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelHigh),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("sexual"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelMedium),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("sexual"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelHigh),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("selfharm"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelMedium),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("selfharm"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelMedium),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("violence"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						AllowedContentLevel: pulumi.String(cognitiveservices.AllowedContentLevelMedium),
 * 						Blocking:            pulumi.Bool(true),
 * 						Enabled:             pulumi.Bool(true),
 * 						Name:                pulumi.String("violence"),
 * 						Source:              pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						Blocking: pulumi.Bool(true),
 * 						Enabled:  pulumi.Bool(true),
 * 						Name:     pulumi.String("jailbreak"),
 * 						Source:   pulumi.String(cognitiveservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						Blocking: pulumi.Bool(true),
 * 						Enabled:  pulumi.Bool(true),
 * 						Name:     pulumi.String("protected_material_text"),
 * 						Source:   pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						Blocking: pulumi.Bool(true),
 * 						Enabled:  pulumi.Bool(true),
 * 						Name:     pulumi.String("protected_material_code"),
 * 						Source:   pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						Blocking: pulumi.Bool(true),
 * 						Enabled:  pulumi.Bool(true),
 * 						Name:     pulumi.String("profanity"),
 * 						Source:   pulumi.String(cognitiveservices.RaiPolicyContentSourcePrompt),
 * 					},
 * 					&cognitiveservices.RaiPolicyContentFilterArgs{
 * 						Blocking: pulumi.Bool(true),
 * 						Enabled:  pulumi.Bool(true),
 * 						Name:     pulumi.String("profanity"),
 * 						Source:   pulumi.String(cognitiveservices.RaiPolicyContentSourceCompletion),
 * 					},
 * 				},
 * 			},
 * 			RaiPolicyName:     pulumi.String("raiPolicyName"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.RaiPolicy;
 * import com.pulumi.azurenative.cognitiveservices.RaiPolicyArgs;
 * import com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var raiPolicy = new RaiPolicy("raiPolicy", RaiPolicyArgs.builder()
 *             .accountName("accountName")
 *             .properties(RaiPolicyPropertiesArgs.builder()
 *                 .basePolicyName("112")
 *                 .contentFilters(
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("High")
 *                         .blocking(false)
 *                         .enabled(false)
 *                         .name("hate")
 *                         .source("Prompt")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("Medium")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("hate")
 *                         .source("Completion")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("High")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("sexual")
 *                         .source("Prompt")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("Medium")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("sexual")
 *                         .source("Completion")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("High")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("selfharm")
 *                         .source("Prompt")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("Medium")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("selfharm")
 *                         .source("Completion")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("Medium")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("violence")
 *                         .source("Prompt")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .allowedContentLevel("Medium")
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("violence")
 *                         .source("Completion")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("jailbreak")
 *                         .source("Prompt")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("protected_material_text")
 *                         .source("Completion")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("protected_material_code")
 *                         .source("Completion")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("profanity")
 *                         .source("Prompt")
 *                         .build(),
 *                     RaiPolicyContentFilterArgs.builder()
 *                         .blocking(true)
 *                         .enabled(true)
 *                         .name("profanity")
 *                         .source("Completion")
 *                         .build())
 *                 .build())
 *             .raiPolicyName("raiPolicyName")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:RaiPolicy raiPolicyName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/raiPolicies/{raiPolicyName}
 * ```
 * @property accountName The name of Cognitive Services account.
 * @property properties Properties of Cognitive Services RaiPolicy.
 * @property raiPolicyName The name of the RaiPolicy associated with the Cognitive Services Account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class RaiPolicyArgs(
    public val accountName: Output<String>? = null,
    public val properties: Output<RaiPolicyPropertiesArgs>? = null,
    public val raiPolicyName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.RaiPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.RaiPolicyArgs =
        com.pulumi.azurenative.cognitiveservices.RaiPolicyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .raiPolicyName(raiPolicyName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RaiPolicyArgs].
 */
@PulumiTagMarker
public class RaiPolicyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var properties: Output<RaiPolicyPropertiesArgs>? = null

    private var raiPolicyName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("iynphhddaaisykuw")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Properties of Cognitive Services RaiPolicy.
     */
    @JvmName("xtevubqtxfaduffx")
    public suspend fun properties(`value`: Output<RaiPolicyPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the RaiPolicy associated with the Cognitive Services Account
     */
    @JvmName("njsmwdjdkromouqc")
    public suspend fun raiPolicyName(`value`: Output<String>) {
        this.raiPolicyName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jtbmmbbiwejmqrev")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("edmohbqlkuywxbtv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("icyhaqrljqelamdq")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Properties of Cognitive Services RaiPolicy.
     */
    @JvmName("wbctmiasmxvxtnbi")
    public suspend fun properties(`value`: RaiPolicyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Cognitive Services RaiPolicy.
     */
    @JvmName("dxefhxxsbrgawtwi")
    public suspend fun properties(argument: suspend RaiPolicyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RaiPolicyPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the RaiPolicy associated with the Cognitive Services Account
     */
    @JvmName("botbjweedvllnyjl")
    public suspend fun raiPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raiPolicyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("flvxakqpntpxunnk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dbqqstargcppxwlo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tmpqdvxdipvwtxlh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RaiPolicyArgs = RaiPolicyArgs(
        accountName = accountName,
        properties = properties,
        raiPolicyName = raiPolicyName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
