@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
 */
public enum class NetworkRuleAction(
    public val javaValue: com.pulumi.azurenative.cognitiveservices.enums.NetworkRuleAction,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.enums.NetworkRuleAction> {
    Allow(com.pulumi.azurenative.cognitiveservices.enums.NetworkRuleAction.Allow),
    Deny(com.pulumi.azurenative.cognitiveservices.enums.NetworkRuleAction.Deny),
    ;

    override fun toJava(): com.pulumi.azurenative.cognitiveservices.enums.NetworkRuleAction =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.enums.NetworkRuleAction): NetworkRuleAction = NetworkRuleAction.values().first { it.javaValue == javaType }
    }
}
