@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.AccountPropertiesArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.PublicNetworkAccess
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of Cognitive Services account.
 * @property allowedFqdnList
 * @property apiProperties The api properties for special APIs.
 * @property customSubDomainName Optional subdomain name used for token-based authentication.
 * @property disableLocalAuth
 * @property dynamicThrottlingEnabled The flag to enable dynamic throttling.
 * @property encryption The encryption properties for this resource.
 * @property locations The multiregion settings of Cognitive Services account.
 * @property migrationToken Resource migration token.
 * @property networkAcls A collection of rules governing the accessibility from specific network locations.
 * @property publicNetworkAccess Whether or not public endpoint access is allowed for this account.
 * @property restore
 * @property restrictOutboundNetworkAccess
 * @property userOwnedStorage The storage accounts for this resource.
 */
public data class AccountPropertiesArgs(
    public val allowedFqdnList: Output<List<String>>? = null,
    public val apiProperties: Output<ApiPropertiesArgs>? = null,
    public val customSubDomainName: Output<String>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val dynamicThrottlingEnabled: Output<Boolean>? = null,
    public val encryption: Output<EncryptionArgs>? = null,
    public val locations: Output<MultiRegionSettingsArgs>? = null,
    public val migrationToken: Output<String>? = null,
    public val networkAcls: Output<NetworkRuleSetArgs>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val restore: Output<Boolean>? = null,
    public val restrictOutboundNetworkAccess: Output<Boolean>? = null,
    public val userOwnedStorage: Output<List<UserOwnedStorageArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.AccountPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.AccountPropertiesArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.AccountPropertiesArgs.builder()
            .allowedFqdnList(allowedFqdnList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .apiProperties(apiProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customSubDomainName(customSubDomainName?.applyValue({ args0 -> args0 }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .dynamicThrottlingEnabled(dynamicThrottlingEnabled?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .locations(locations?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .migrationToken(migrationToken?.applyValue({ args0 -> args0 }))
            .networkAcls(networkAcls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .restore(restore?.applyValue({ args0 -> args0 }))
            .restrictOutboundNetworkAccess(restrictOutboundNetworkAccess?.applyValue({ args0 -> args0 }))
            .userOwnedStorage(
                userOwnedStorage?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AccountPropertiesArgs].
 */
@PulumiTagMarker
public class AccountPropertiesArgsBuilder internal constructor() {
    private var allowedFqdnList: Output<List<String>>? = null

    private var apiProperties: Output<ApiPropertiesArgs>? = null

    private var customSubDomainName: Output<String>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var dynamicThrottlingEnabled: Output<Boolean>? = null

    private var encryption: Output<EncryptionArgs>? = null

    private var locations: Output<MultiRegionSettingsArgs>? = null

    private var migrationToken: Output<String>? = null

    private var networkAcls: Output<NetworkRuleSetArgs>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var restore: Output<Boolean>? = null

    private var restrictOutboundNetworkAccess: Output<Boolean>? = null

    private var userOwnedStorage: Output<List<UserOwnedStorageArgs>>? = null

    /**
     * @param value
     */
    @JvmName("ncdyxictouuigmqm")
    public suspend fun allowedFqdnList(`value`: Output<List<String>>) {
        this.allowedFqdnList = value
    }

    @JvmName("bhmdkjeehcgpikbd")
    public suspend fun allowedFqdnList(vararg values: Output<String>) {
        this.allowedFqdnList = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ohtorjcsaxqvcalk")
    public suspend fun allowedFqdnList(values: List<Output<String>>) {
        this.allowedFqdnList = Output.all(values)
    }

    /**
     * @param value The api properties for special APIs.
     */
    @JvmName("iucoajghhscrbhkj")
    public suspend fun apiProperties(`value`: Output<ApiPropertiesArgs>) {
        this.apiProperties = value
    }

    /**
     * @param value Optional subdomain name used for token-based authentication.
     */
    @JvmName("xlblhbmwahmtsglx")
    public suspend fun customSubDomainName(`value`: Output<String>) {
        this.customSubDomainName = value
    }

    /**
     * @param value
     */
    @JvmName("tgkipksrenvgvfhu")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value The flag to enable dynamic throttling.
     */
    @JvmName("fcvppwivoocnlkbj")
    public suspend fun dynamicThrottlingEnabled(`value`: Output<Boolean>) {
        this.dynamicThrottlingEnabled = value
    }

    /**
     * @param value The encryption properties for this resource.
     */
    @JvmName("atoowtbehrhxaxtb")
    public suspend fun encryption(`value`: Output<EncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value The multiregion settings of Cognitive Services account.
     */
    @JvmName("nmikmybrajfojpsf")
    public suspend fun locations(`value`: Output<MultiRegionSettingsArgs>) {
        this.locations = value
    }

    /**
     * @param value Resource migration token.
     */
    @JvmName("uoksygreiqtidfcs")
    public suspend fun migrationToken(`value`: Output<String>) {
        this.migrationToken = value
    }

    /**
     * @param value A collection of rules governing the accessibility from specific network locations.
     */
    @JvmName("ynxonjnqnsgivbge")
    public suspend fun networkAcls(`value`: Output<NetworkRuleSetArgs>) {
        this.networkAcls = value
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this account.
     */
    @JvmName("gdjpkejqgegdrgom")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value
     */
    @JvmName("ffykfyulwceylxof")
    public suspend fun restore(`value`: Output<Boolean>) {
        this.restore = value
    }

    /**
     * @param value
     */
    @JvmName("mnfkalavjgrdtqnk")
    public suspend fun restrictOutboundNetworkAccess(`value`: Output<Boolean>) {
        this.restrictOutboundNetworkAccess = value
    }

    /**
     * @param value The storage accounts for this resource.
     */
    @JvmName("vtfbrvkwbmabtoqf")
    public suspend fun userOwnedStorage(`value`: Output<List<UserOwnedStorageArgs>>) {
        this.userOwnedStorage = value
    }

    @JvmName("budyeedcqunfdrbb")
    public suspend fun userOwnedStorage(vararg values: Output<UserOwnedStorageArgs>) {
        this.userOwnedStorage = Output.all(values.asList())
    }

    /**
     * @param values The storage accounts for this resource.
     */
    @JvmName("eptarlddouldxxni")
    public suspend fun userOwnedStorage(values: List<Output<UserOwnedStorageArgs>>) {
        this.userOwnedStorage = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("caobqeekuuytgork")
    public suspend fun allowedFqdnList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedFqdnList = mapped
    }

    /**
     * @param values
     */
    @JvmName("flfvydtjorjsfprw")
    public suspend fun allowedFqdnList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedFqdnList = mapped
    }

    /**
     * @param value The api properties for special APIs.
     */
    @JvmName("mceomhxsltycdclj")
    public suspend fun apiProperties(`value`: ApiPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiProperties = mapped
    }

    /**
     * @param argument The api properties for special APIs.
     */
    @JvmName("ioimhtypbjjjjrtf")
    public suspend fun apiProperties(argument: suspend ApiPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ApiPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiProperties = mapped
    }

    /**
     * @param value Optional subdomain name used for token-based authentication.
     */
    @JvmName("xeimncigllvhwmjf")
    public suspend fun customSubDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSubDomainName = mapped
    }

    /**
     * @param value
     */
    @JvmName("tfgwrrkgatwlrfay")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value The flag to enable dynamic throttling.
     */
    @JvmName("ylvmedabvdqyiduf")
    public suspend fun dynamicThrottlingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicThrottlingEnabled = mapped
    }

    /**
     * @param value The encryption properties for this resource.
     */
    @JvmName("yydtqoqsbtrljdwc")
    public suspend fun encryption(`value`: EncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument The encryption properties for this resource.
     */
    @JvmName("uimoismnyqftbfoo")
    public suspend fun encryption(argument: suspend EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The multiregion settings of Cognitive Services account.
     */
    @JvmName("dlladcrmykjumhma")
    public suspend fun locations(`value`: MultiRegionSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param argument The multiregion settings of Cognitive Services account.
     */
    @JvmName("gfdvwlrfclbunqah")
    public suspend fun locations(argument: suspend MultiRegionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = MultiRegionSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.locations = mapped
    }

    /**
     * @param value Resource migration token.
     */
    @JvmName("tfucnmotmokjlrfh")
    public suspend fun migrationToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationToken = mapped
    }

    /**
     * @param value A collection of rules governing the accessibility from specific network locations.
     */
    @JvmName("agexoqulsaqyoniq")
    public suspend fun networkAcls(`value`: NetworkRuleSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAcls = mapped
    }

    /**
     * @param argument A collection of rules governing the accessibility from specific network locations.
     */
    @JvmName("huqvpylysfeffbpb")
    public suspend fun networkAcls(argument: suspend NetworkRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkRuleSetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkAcls = mapped
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this account.
     */
    @JvmName("lsenfvxhpthdlgbe")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this account.
     */
    @JvmName("icyqcauwgfrxpcgp")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this account.
     */
    @JvmName("wfqrgcpuvsfnpymc")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value
     */
    @JvmName("bgxgeygaadbvtrgw")
    public suspend fun restore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restore = mapped
    }

    /**
     * @param value
     */
    @JvmName("dekpsfqnedavtaep")
    public suspend fun restrictOutboundNetworkAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restrictOutboundNetworkAccess = mapped
    }

    /**
     * @param value The storage accounts for this resource.
     */
    @JvmName("hcqyxhhnijonhobx")
    public suspend fun userOwnedStorage(`value`: List<UserOwnedStorageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userOwnedStorage = mapped
    }

    /**
     * @param argument The storage accounts for this resource.
     */
    @JvmName("fjfrfteguwnkhrat")
    public suspend fun userOwnedStorage(argument: List<suspend UserOwnedStorageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserOwnedStorageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.userOwnedStorage = mapped
    }

    /**
     * @param argument The storage accounts for this resource.
     */
    @JvmName("iljtislxihpwhkdd")
    public suspend fun userOwnedStorage(vararg argument: suspend UserOwnedStorageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserOwnedStorageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.userOwnedStorage = mapped
    }

    /**
     * @param argument The storage accounts for this resource.
     */
    @JvmName("lvttytleixkblvlp")
    public suspend fun userOwnedStorage(argument: suspend UserOwnedStorageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserOwnedStorageArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userOwnedStorage = mapped
    }

    /**
     * @param values The storage accounts for this resource.
     */
    @JvmName("oerkqdhjkgfvehvt")
    public suspend fun userOwnedStorage(vararg values: UserOwnedStorageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userOwnedStorage = mapped
    }

    internal fun build(): AccountPropertiesArgs = AccountPropertiesArgs(
        allowedFqdnList = allowedFqdnList,
        apiProperties = apiProperties,
        customSubDomainName = customSubDomainName,
        disableLocalAuth = disableLocalAuth,
        dynamicThrottlingEnabled = dynamicThrottlingEnabled,
        encryption = encryption,
        locations = locations,
        migrationToken = migrationToken,
        networkAcls = networkAcls,
        publicNetworkAccess = publicNetworkAccess,
        restore = restore,
        restrictOutboundNetworkAccess = restrictOutboundNetworkAccess,
        userOwnedStorage = userOwnedStorage,
    )
}
