@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.GetEncryptionScopePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of Cognitive Services account.
 * @property encryptionScopeName The name of the encryptionScope associated with the Cognitive Services Account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetEncryptionScopePlainArgs(
    public val accountName: String,
    public val encryptionScopeName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.GetEncryptionScopePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.GetEncryptionScopePlainArgs = com.pulumi.azurenative.cognitiveservices.inputs.GetEncryptionScopePlainArgs.builder()
        .accountName(accountName.let({ args0 -> args0 }))
        .encryptionScopeName(encryptionScopeName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEncryptionScopePlainArgs].
 */
@PulumiTagMarker
public class GetEncryptionScopePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var encryptionScopeName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("rsbladaulfevnsim")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the encryptionScope associated with the Cognitive Services Account
     */
    @JvmName("asnondkpxieeowxq")
    public suspend fun encryptionScopeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.encryptionScopeName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("avbbrugjolqgvvlo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEncryptionScopePlainArgs = GetEncryptionScopePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        encryptionScopeName = encryptionScopeName ?: throw PulumiNullFieldException("encryptionScopeName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
