@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.GetSharedCommitmentPlanPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property commitmentPlanName The name of the commitmentPlan associated with the Cognitive Services Account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetSharedCommitmentPlanPlainArgs(
    public val commitmentPlanName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.GetSharedCommitmentPlanPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.GetSharedCommitmentPlanPlainArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.GetSharedCommitmentPlanPlainArgs.builder()
            .commitmentPlanName(commitmentPlanName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSharedCommitmentPlanPlainArgs].
 */
@PulumiTagMarker
public class GetSharedCommitmentPlanPlainArgsBuilder internal constructor() {
    private var commitmentPlanName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the commitmentPlan associated with the Cognitive Services Account
     */
    @JvmName("qsvoskesynmhcuhr")
    public suspend fun commitmentPlanName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.commitmentPlanName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bdttlxwoflbeahlr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetSharedCommitmentPlanPlainArgs = GetSharedCommitmentPlanPlainArgs(
        commitmentPlanName = commitmentPlanName ?: throw PulumiNullFieldException("commitmentPlanName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
