@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.NetworkRuleSetArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.NetworkRuleAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A set of rules governing the network accessibility.
 * @property defaultAction The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
 * @property ipRules The list of IP address rules.
 * @property virtualNetworkRules The list of virtual network rules.
 */
public data class NetworkRuleSetArgs(
    public val defaultAction: Output<Either<String, NetworkRuleAction>>? = null,
    public val ipRules: Output<List<IpRuleArgs>>? = null,
    public val virtualNetworkRules: Output<List<VirtualNetworkRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.NetworkRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.NetworkRuleSetArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.NetworkRuleSetArgs.builder()
            .defaultAction(
                defaultAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipRules(
                ipRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .virtualNetworkRules(
                virtualNetworkRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkRuleSetArgs].
 */
@PulumiTagMarker
public class NetworkRuleSetArgsBuilder internal constructor() {
    private var defaultAction: Output<Either<String, NetworkRuleAction>>? = null

    private var ipRules: Output<List<IpRuleArgs>>? = null

    private var virtualNetworkRules: Output<List<VirtualNetworkRuleArgs>>? = null

    /**
     * @param value The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     */
    @JvmName("qlywaxguhvauyrfr")
    public suspend fun defaultAction(`value`: Output<Either<String, NetworkRuleAction>>) {
        this.defaultAction = value
    }

    /**
     * @param value The list of IP address rules.
     */
    @JvmName("dkwctrqhecefsedj")
    public suspend fun ipRules(`value`: Output<List<IpRuleArgs>>) {
        this.ipRules = value
    }

    @JvmName("utjjnbbrwcxncrfo")
    public suspend fun ipRules(vararg values: Output<IpRuleArgs>) {
        this.ipRules = Output.all(values.asList())
    }

    /**
     * @param values The list of IP address rules.
     */
    @JvmName("curwqoxcyuligrhg")
    public suspend fun ipRules(values: List<Output<IpRuleArgs>>) {
        this.ipRules = Output.all(values)
    }

    /**
     * @param value The list of virtual network rules.
     */
    @JvmName("nidmtxidtlpjjppd")
    public suspend fun virtualNetworkRules(`value`: Output<List<VirtualNetworkRuleArgs>>) {
        this.virtualNetworkRules = value
    }

    @JvmName("lwfwgygxqgcpwgfi")
    public suspend fun virtualNetworkRules(vararg values: Output<VirtualNetworkRuleArgs>) {
        this.virtualNetworkRules = Output.all(values.asList())
    }

    /**
     * @param values The list of virtual network rules.
     */
    @JvmName("fsfuoligydoxrlvr")
    public suspend fun virtualNetworkRules(values: List<Output<VirtualNetworkRuleArgs>>) {
        this.virtualNetworkRules = Output.all(values)
    }

    /**
     * @param value The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     */
    @JvmName("rtaasnkqaydqumyl")
    public suspend fun defaultAction(`value`: Either<String, NetworkRuleAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     */
    @JvmName("pmhhfltkhqhmpbnr")
    public fun defaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkRuleAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     */
    @JvmName("yynjuxnylqorenhm")
    public fun defaultAction(`value`: NetworkRuleAction) {
        val toBeMapped = Either.ofRight<String, NetworkRuleAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The list of IP address rules.
     */
    @JvmName("jmuaqxkdrntxersk")
    public suspend fun ipRules(`value`: List<IpRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param argument The list of IP address rules.
     */
    @JvmName("gssgolxwousigyqq")
    public suspend fun ipRules(argument: List<suspend IpRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument The list of IP address rules.
     */
    @JvmName("jeblocapllteqqvm")
    public suspend fun ipRules(vararg argument: suspend IpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument The list of IP address rules.
     */
    @JvmName("kbwflxmkgnloqpwm")
    public suspend fun ipRules(argument: suspend IpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param values The list of IP address rules.
     */
    @JvmName("pjtstdgmvevkkktr")
    public suspend fun ipRules(vararg values: IpRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param value The list of virtual network rules.
     */
    @JvmName("wcyulyykkfofgird")
    public suspend fun virtualNetworkRules(`value`: List<VirtualNetworkRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules.
     */
    @JvmName("akuayaimmdmdldpw")
    public suspend fun virtualNetworkRules(argument: List<suspend VirtualNetworkRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules.
     */
    @JvmName("fiwpkheooatpwxdg")
    public suspend fun virtualNetworkRules(vararg argument: suspend VirtualNetworkRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules.
     */
    @JvmName("grelxsvuoipshirf")
    public suspend fun virtualNetworkRules(argument: suspend VirtualNetworkRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualNetworkRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param values The list of virtual network rules.
     */
    @JvmName("uoorplxsemspjste")
    public suspend fun virtualNetworkRules(vararg values: VirtualNetworkRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    internal fun build(): NetworkRuleSetArgs = NetworkRuleSetArgs(
        defaultAction = defaultAction,
        ipRules = ipRules,
        virtualNetworkRules = virtualNetworkRules,
    )
}
