@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistItemPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * RAI Custom Blocklist Item properties.
 * @property isRegex If the pattern is a regex pattern.
 * @property pattern Pattern to match against.
 */
public data class RaiBlocklistItemPropertiesArgs(
    public val isRegex: Output<Boolean>? = null,
    public val pattern: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistItemPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistItemPropertiesArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistItemPropertiesArgs.builder()
            .isRegex(isRegex?.applyValue({ args0 -> args0 }))
            .pattern(pattern?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RaiBlocklistItemPropertiesArgs].
 */
@PulumiTagMarker
public class RaiBlocklistItemPropertiesArgsBuilder internal constructor() {
    private var isRegex: Output<Boolean>? = null

    private var pattern: Output<String>? = null

    /**
     * @param value If the pattern is a regex pattern.
     */
    @JvmName("ggtbindwcpfwdufp")
    public suspend fun isRegex(`value`: Output<Boolean>) {
        this.isRegex = value
    }

    /**
     * @param value Pattern to match against.
     */
    @JvmName("wmptyimmgqnbgbjw")
    public suspend fun pattern(`value`: Output<String>) {
        this.pattern = value
    }

    /**
     * @param value If the pattern is a regex pattern.
     */
    @JvmName("ruhjypqikvitewdx")
    public suspend fun isRegex(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRegex = mapped
    }

    /**
     * @param value Pattern to match against.
     */
    @JvmName("yiwikukcmoojtbxn")
    public suspend fun pattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pattern = mapped
    }

    internal fun build(): RaiBlocklistItemPropertiesArgs = RaiBlocklistItemPropertiesArgs(
        isRegex = isRegex,
        pattern = pattern,
    )
}
