@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * RAI Custom Blocklist properties.
 * @property description Description of the block list.
 */
public data class RaiBlocklistPropertiesArgs(
    public val description: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistPropertiesArgs = com.pulumi.azurenative.cognitiveservices.inputs.RaiBlocklistPropertiesArgs.builder()
        .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RaiBlocklistPropertiesArgs].
 */
@PulumiTagMarker
public class RaiBlocklistPropertiesArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    /**
     * @param value Description of the block list.
     */
    @JvmName("diikprkjgmxghrqx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Description of the block list.
     */
    @JvmName("uhtgmcmocvorwqso")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): RaiBlocklistPropertiesArgs = RaiBlocklistPropertiesArgs(
        description = description,
    )
}
